program CrtDemo;
{ Demonstracja niektorych procedur modulu Crt }

uses
  Crt;

var
  ch : char; { wpisany znak }

procedure Wait; { czekaj na klawisz }

begin
  ch:=ReadKey { oczekiwanie na dowolny klawisz }
end;

procedure Gwiazdki;
{ demonstruje wypisywanie przez BIOS i bezposrednio }

var
  i : integer;

begin
  DirectVideo:=false;   { dostep do ekranu przez BIOS }
  for i:=1 to 1800 do   { zapisz ekran gwiazdkami }
    write('*');
  Wait;                 { czekaj }
  ClrScr;               { wyczysc ekran }
  DirectVideo:=true;   { szybki dostep do ekranu }
  Wait; 
  for i:=1 to 1800 do
    write('*');
  TextAttr:=Blink + Red shl 4 + White; 
  { TextAttr okresla kolor znakow/tla }
  GotoXY(25,12);   { pisz od pozycji x=25, y=12 }
  writeln('Efekt piorunujacy, nieprawdaz ?');
  Wait;
end;

procedure Okno;
{ demonstruje okno tekstowe }

var
  i : integer;

begin
  Window(20,10,50,20);  { wspolrzedne aktywnego okna tekst. }
  TextColor(White);
  TextBackground(Green);
  ClrScr;               { tylko okno }
  for i:=1 to 100 do   { wypisuj w oknie }
    write('Zapis do okna ');
  Window(1,1,80,25);   { przywroc okno pelnoekranowe }
  Wait;
  ClrScr
end;

procedure Syrena;
{ efekty dzwiekowe }

const
  i : integer = 1000;

begin
  writeln('Nieco efektow dzwiekowych',
          ' (nacisnij dowolny klawisz):');
  repeat
    Sound(i); { dzwiek o czestotliwosci i hercow }
    Delay(1); { opoznienie 1 milisekunde }
    if i > 2000 then i:=1000 else Inc(i)
  until KeyPressed; { zwraca true gdy nacisnieto klawisz }
  NoSound
end;

procedure Kody;
{ demonstracja funkcji ReadKey }

begin
  writeln('Teraz dowiesz sie, jakie kody maja rozne klawisze',
           ' (naciskaj je, <Esc> - koniec):');
  repeat
    Wait;
    if ch = #0 then { kod tzw. roszerzony... }
      begin
        Wait; { ...przekazywany w drugim wywolaniu }
        writeln('Nacisnales klawisz o kodzie rozszerzonym',
                ord(ch),' (',ch,').')
      end
    else writeln('Nacisnales klawisz o kodzie ',ord(ch),
                  '(',ch,').');
  until ch = #27;
  ClrScr;
end;

begin { program }
  TextColor(Yellow);     { zolte litery }
  TextBackground(Blue);   { niebieskie tlo }
  ClrScr;                 { oczysc ekran }
  Gwiazdki;   { demonstracja szybkosci procedur pisania }
  Okno;                   { okno tekstowe }
  Syrena;                 { procedury obslugi glosnika }
  Kody                   { kody zwracane przez ReadKey }
end. { program CRTDemo }