program Sinusy;
{ demonstracja mozliwosci modulu Graph }

uses
  Crt,Graph;

const
  MargY = 60; { margines na opis OY }
  MargX = 30; { margines na opis OX }
  MAXPKT = 1000; { maks. liczba punktow wykresu }

var
  WartXY : array[0..MAXPKT] of PointType; {wspolrzedne wykresu}
  Wartosci : array[0..MAXPKT] of real;                    { wartosci funkcji }
  Maksimum : integer;                                     { maksimum funkcji }
  ZakresX : integer;                        { zakres wspolrzednych na osi OX }
  X0,Y0,Xm,Ym : integer;                           { max. wspolrzedne ekranu }
  Kursor : pointer;                       { wskaznik do mapy bitowej kursora }
  RozmKursora : word;                         { rozmiar mapy bitowej kursora }

procedure Start;
{ inicjalizacja trybu graf. i utworzenie kursora }

var
  Driver,Tryb : integer;
  Rozmiar : word;

begin
  Driver:=Detect;   { autodetekcja karty }
  InitGraph(Driver,Tryb,'c:\tp\bgi'); { start grafiki }
  Xm:=GetMaxX;     { max. wspolrzedne }
  Ym:=GetMaxY;
  Line(0,6,20,6);   { wykresl kursor }
  Line(10,0,10,12);
  RozmKursora:=ImageSize(0,0,20,12);  { ile trzeba bajtow ? }
  GetMem(Kursor,RozmKursora);         { zarezerwuj pamiec }
  GetImage(0,0,20,12,Kursor^);     { pobierz mape bitowa }
  PutImage(0,0,Kursor^,XORPut); {skasuj kursor przez nalozenie}
end;

function Zlozenie(x:real):real; { zlozenie sin-cos }
{ tu mozesz sie wyszalec ! }

begin
  Zlozenie:=sin(3*x)*cos(1.5*x)*sin(6*x)+2*cos(10*x)*sin(2.5*x)
end;

procedure ObliczFunkcje;
{ obliczenie wartosci i maksimum funkcji}

const
  WartMax : real = 0.0;

var
  i  : integer;
  dx : real;

begin
  ZakresX:=Xm-MargY; { zakres wspolrzednych x wykresu }
  dx:=2*Pi/(Xm-MargY); { oblicz wartosc kroku argumentu }
  for i:=0 to ZakresX do
    begin
      Wartosci[i]:=Zlozenie(dx*i); { oblicz kolejny punkt }
      if Wartosci[i] > WartMax then WartMax:=Wartosci[i]
    end; { ^ znajdz maksimum funkcji ^ }
  Maksimum:=trunc(WartMax)+1 { zaokraglij w gore }
end;

procedure Ramka;
{ kreslenie ramki }

var
  i,j   : integer;
  x,y   : integer;
  s     : string;
  lxm,lym : integer; { lokalne granice }

begin
  ClearViewPort;
  lxm:=Xm-MargY;           { zostaw miejsce na opis osi y }
  lym:=Ym-MargX;           { i osi x }
  SetColor(Yellow);         { ustaw kolory }
  SetBkColor(Blue);
  Rectangle(0,0,lxm,lym);{ kresl ramke }
  SetColor(LightGreen);
  SetTextJustify(CenterText,CenterText); { lokalizacja napisu}
  SetLineStyle(DottedLn,0,NormWidth); { cienka linia kropkowa}
  for i:=1 to 11 do { skala X co 30 stopni }
    begin { zwroc uwage na obliczenie wspolrzednych }
      x:=round(i*lxm/12);   { zaokraglenie - porownaj trunc }
      Line(x,1,x,lym)       { siatka pionowa }
    end;
  OutTextXY(1,lym+10,'0');  { opis osi OX }
  OutTextXY(lxm div 2,lym+10,'180');
  OutTextXY(lxm,lym+10,'360');
  for i:=0 to 2*Maksimum do { opis osi OY }
    begin
      y:=round(i*lym/2/Maksimum);  { oblicz wspolrzedne }
      Line(1,y,lxm,y);             { siatka pozioma }
      Str((Maksimum-i):4,s); { zamienia liczbe na lancuch }
      OutTextXY(lxm+10,round((y+10)/1.05),s); { dla opisu osi}
    end;
  y:=round(lym/2); { polozenie linii zerowej }
  SetLineStyle(SolidLn,0,NormWidth);  { cienka linia ciagla }
  Line(0,y,lxm,y);                   { linia zerowa }
  SetTextJustify(LeftText,BottomText) { normalne poloz. tekstu}
end;

procedure KreslWykres;
{ wykres wlasciwy }

var
  i : integer;

begin
  SetColor(LightRed);
  for i:=0 to ZakresX do
    with WartXY[i] do { ??! }
      begin { oblicz kolejne punkty wykresu }
        x:=i+2; { wsp. x i (nizej) y }
        y:=round((Maksimum-Wartosci[i])/Maksimum*(Ym-MargX)/2)
      end;
  DrawPoly(ZakresX,WartXY) { Ctrl-F1... }
end;

procedure KreslKursor(x:integer);
{ kresli kursor na wykresie }

begin
  with WartXY[x] do
    PutImage(x-10,y-6,Kursor^,XORPut); {umiesc kursor na (x,y)}
end;

procedure PiszWartosci(x:integer);
{ wypisuje wartosci funkcji }

var
  s1,s2 : string;

begin
  Str(x/ZakresX*360:8:4,s1);  { jaka wartosc argumentu ? }
  Str(Wartosci[x]:8:4,s2);  { jaka wartosc funkcji ? }
  s1:='x= '+s1+', y='+s2;  { sklej to w calosc }
  SetViewPort(0,Ym-9,TextWidth(s1),Ym,ClipOff);
  { maly pasek o dlugosci wypisywanego lancucha na dole ekranu}
  ClearViewPort;             { usun poprzednia zawartosc }
  OutTextXY(0,9,s1);         { i wypisz }
  SetViewPort(0,0,Xm,Ym,ClipOff); { przywroc poprz. okno graf.}
end;

procedure Badanie;
{ badanie wartosci funkcji }

const
  KursorLewo  = #75; { kod klawisza "kursor w lewo" }
  KursorPrawo = #77; { i "w prawo" }
  Escape     = #27; { kod klawisza Escape }

var
  ch : char;
  x : integer;

begin
  x:=ZakresX div 2; { kursor w polowie wykresu }
  KreslKursor(x);
  repeat
    ch:=ReadKey; { czytaj klawiature }
    if ch = #0 then ch:=ReadKey; { rozszerzony kod klawisza }
    KreslKursor(x); { kasuj stary kursor }
    case ch of { jesli wczytany znak = ... }
         KursorLewo : Dec(x); { w lewo }
         KursorPrawo : Inc(x) { w prawo }
      end;
    KreslKursor(x);   { kresl kursor na nowej pozycji }
    PiszWartosci(x)   { wypisz wartosci x, y }
  until ch = Escape;  { skoncz po nacisnieciu <Esc> }
end;

procedure Stop;
{ zamkniecie grafiki i porzadki z pamiecia }

begin
  ClearDevice;     { graficzny ClrScr }
  Delay(1000);     { zebys zobaczyl efekt }
  CloseGraph;      { koniec grafiki }
  FreeMem(Kursor,RozmKursora) {zwolnij pamiec zajeta na kursor}
end;

begin { program }
  Start;             { otwarcie grafiki }
  OutText('Czekaj - nie panikuj...');
  ObliczFunkcje;     { tablicowanie funkcji }
  Ramka;             { kreslenie ramki }
  KreslWykres;       { i wykresu }
  Badanie;           { badanie wartosci funkcji }
  Stop               { koniec programu }
end. { program Sinusy }