program Kadrowa;
{ prosta baza danych }

uses
  Crt;

type
  DanePers = record { opis pojedynczego pracownika }
               Imie       : string[15];
               Nazwisko  : string[20];
               Plec       : char;
               Wiek       : byte;
               Dochody   : real
             end;

const
  Ostatni : integer = 0; { ostatni rekord = 0 na poczatku }

var
  Dane : array[1..1000] of DanePers; { lista pracownikow }
  BazaDanych : file of DanePers;    { plik z danymi }

procedure WpisDanych(var Rekord:DanePers);
{ czyta dane pracownika z klawiatury }

var
  ch : char;

begin
  ClrScr;
  with Rekord do { do poszczegolnych pol rekordu }
    begin
      write('Imie      : '); { bez komentarza }
      readln(Imie);
      write('Nazwisko  : ');
      readln(Nazwisko);
      write('Plec (M/K) :');
      repeat { czytaj do oporu }
        ch:=UpCase(ReadKey)   { zamien na duza litere }
      until ch in ['M','K'];   { az wlasciwy klawisz }
      Plec:=ch;
      writeln;
      write('Wiek      : ');
      readln(Wiek);
      write('Dochody    : ');
      readln(Dochody)
    end;
  Inc(Ostatni) { zwieksz liczbe aktywnych rekordow }
end;

procedure ZapisNaDysku;
{ zapisuje baze danych na dysku }

var
  Nazwa : string;
  i : integer;

begin
  write('Nazwa bazy danych: ');
  readln(Nazwa);
  assign(BazaDanych,Nazwa);
  rewrite(BazaDanych);           { otworz plik }
   for i:=1 to Ostatni do      { zapisz baze do pliku }
    write(BazaDanych,Dane[i]);   { zapisz caly rekord }
  close(BazaDanych)               { zamknij plik ! }
end;
  
function OdczytZDysku:integer;
{ odczytuje baze danych z dysku }
var
  Nazwa : string;
  i : integer;

begin
  write('Nazwa bazy danych: ');
  readln(Nazwa);
  assign(BazaDanych,Nazwa);
  reset(BazaDanych);
  i:=1;
  while not eof(BazaDanych) do { czytaj az do konca pliku }
    begin
      read(BazaDanych,Dane[i]);   { czytaj kolejny rekord }
      Inc(i) { zwieksz wskaznik tablicy }
    end;
  close(BazaDanych);             { zamknij plik ! }
  OdczytZDysku:=pred(i) { zwroc liczbe przeczytanych rekordow}
end;

procedure PrzegladDanych;
{ przegladanie bazy danych }


const
  KursorLewo     = #75; { to juz bylo - czy nie irytuje Cie }
  KursorPrawo   = #77; { fakt, ze trzeba to wpisywac w kazdy }
  Esc           = #27; { nowy program ? }

var
  i : integer;
  ch : char;

  procedure WyswietlRekord(NrRekordu:integer);
  { przyklad procedury zdefiniowanej w procedurze }
  { jak myslisz, gdzie jest widoczna ? }

  begin { wyswietl pojedynczy rekord }
    ClrScr;
    writeln('Rekord nr ',i,':');
    writeln;
    with Dane[i] do
      begin
        writeln('Imie     : ',Imie);
        writeln('Nazwisko: ',Nazwisko);
        writeln('Plec     : ',Plec);
        writeln('Wiek     : ',Wiek);
        writeln('Dochody : ',Dochody:9:2)
      end;
    writeln
  end;

begin
  i:=1; { pierwszy rekord }
  repeat
    WyswietlRekord(i);
    writeln('<-: poprzedni rekord,  ->: nastepny rekord  Esc:',
            ' koniec');
    repeat
      ch:=ReadKey;
    until ch in [KursorLewo,KursorPrawo,Esc];
    case ch of { uwaga na granice tablicy ! }
         KursorLewo : if i > 1 then Dec(i);
         KursorPrawo : if i < Ostatni then Inc(i)
      end
  until ch = Esc
end;

function Menu:integer;
{ proste menu glowne }

var
  ch : char;

begin
  ClrScr; { wyczysc ekran, wyswietl menu }
  writeln('MENU: '); { bez komentarza }
  writeln('1: Wpis danych osobowych');
  writeln('2: Zapis danych na dysku');
  writeln('3: Odczyt danych z dysku');
  writeln('4: Przegladanie danych');
  writeln('0: Koniec pracy');
  repeat { czekaj na wybor uzytkownika }
    ch:=ReadKey
  until ch in ['0'..'4']; { przynaleznosc do zakresu }
  Menu:=ord(ch)-ord('0') { przeksztalcenie znaku na liczbe }
end;

begin { program }
  repeat { typowa konstrukcja programu }
    case Menu of { sterowanego menu }
         1 : WpisDanych(Dane[succ(Ostatni)]);
         2 : ZapisNaDysku;
         3 : Ostatni:=OdczytZDysku;
         4 : if Ostatni > 0 then PrzegladDanych;
         0 : Halt(0) { zatrzymanie programu }
       end
  until false { co powiesz o tej petli ? }
end. { program Kadrowa }