unit InterfejsUzytkownika;
{ procedury obslugi interfejsu uzytkownika }

interface { deklaracje publiczne }

uses
  Crt;

const
  Enter   = #13;    { kody klawiszy Enter i Esc }
                   { dla wygody programisty }
  Esc     = #27;   { w module nieuzywane, ale sie przydaja }
  MaxOpcja = 9;     { max. dopuszczalna liczba opcji w menu }

type
  string30 = string[30]; { lancuch 30 znakow - oszczedny }
  TablOpcji = array[1..MaxOpcja] of string30; 
          { tablica opcji dla Menu }

var
  ch : char; { zmienna globalna do zwracania kodu klawisza }
  PoprzedniX,PoprzedniY : byte; { poz. kursora przed PiszXY }

procedure Czekaj;
{ czeka na nacisniecie klawisza i zwraca jego kod w ch }

procedure Buczek(Hz:word;Czas:real);
{ generuje dzwiek o dlugosci Czas i czestotliwosci Hz }

procedure PiszXY(x,y:byte;s:string);
{ umieszcza lancuch s na ekranie w miejscu (x,y) }

procedure CzytajReal(var q:real;x,y:byte;Zaproszenie:string);
{ wypisuje zaproszenie do wprowadzenia liczby na wsp. (x,y) }
{ i wczytuje te liczbe }

procedure UstawKolory(KolorZnakow,KolorTla:byte);
{ ustawia jednoczesnie kolor znakow i tla }

procedure OdtworzKolory;
{ odtwarza poprzednie kolory znakow i tla }

function Menu(x,y:byte;LiczbaOpcji:byte;Opcje:TablOpcji):byte;
{ wyswietla proste menu na wsp. (x,y) i pozwala wybrac opcje }
{ zwraca jej numer lub 0, jesli nacisniesz Esc }

function Szlaczek(Zn:char;Dlug:byte):string;
{ zwraca lancuch znakow Zn o dlugosci Dlug }

implementation { deklaracje prywatne i definicje }

var { prywatna statyczna zmienna modulu }
  PoprzednieKolory : byte; { poprzednie kolory ekranu }

procedure Czekaj; { uwaga na zgodnosc naglowkow }

begin
  ch:=ReadKey;     { czekaj na klawisz }
  if ch = #0 then   { kod rozszerzony }
    ch:=ReadKey     { odczytaj kod }
end;

procedure Buczek(Hz:word;Czas:real);

var
  i : integer; { lokalna zmienna pomocnicza }

begin                 { skad my to znamy...? }
  i:=round(Czas*1000);  { przelicz czas na milisekundy }
  Sound(Hz);           { wlacz buczek }
  Delay(i);             { czekaj Czas*1000 milisekund }
  NoSound               { wylacz buczek }
end;


procedure PiszXY(x,y:byte;s:string);

begin
  PoprzedniX:=WhereX; {zapamietaj poprzednie polozenie kursora}
  PoprzedniY:=WhereY;   { na wszelki wypadek }
  GotoXY(x,y);         { ustaw kursor na nowym miejscu }
  write(s);             { wypisz lancuch }
end;

procedure CzytajReal(var q:real;x,y:byte;Zaproszenie:string);

var
  s : string; { pomocniczy lancuch }
  Blad : integer; { kod bledu procedury Val }

begin
  repeat
    PiszXY(x,y,Zaproszenie); { wypisz zaproszenie }
    readln(s);       { czytaj liczbe jako lancuch (po co ?) }
    Val(s,q,Blad); { czy wpisano liczbe poprawnie }
    if Blad <> 0 then Buczek(1000,0.2); { nie - alarm }
  until Blad = 0 { az wczytana zostanie poprawna liczba }
end;

procedure UstawKolory(KolorZnakow,KolorTla:byte);

begin
  PoprzednieKolory:=TextAttr; { zapamietaj atrybuty }
  TextColor(KolorZnakow); { i ustaw nowe }
  TextBackground(KolorTla)
end;

procedure OdtworzKolory;

begin
  TextAttr:=PoprzednieKolory; { odtworz atrybuty }
end;

function Menu(x,y:byte;LiczbaOpcji:byte;Opcje:TablOpcji):byte;

var
  i : integer;           { licznik }
  s : string;             { lancuch do wypis. biezacej opcji }
  OstatniaOpcja : char;   { zwroc na to uwage }

begin
  OstatniaOpcja:=chr(LiczbaOpcji+ord('0')); { cyfra na znak }
  for i:=1 to LiczbaOpcji do { wypisz wszystkie opcje }
    begin
      Str(i,s);             { kolejny numer opcji na lancuch }
      s:=s+': '+Opcje[i];   { pelna postac opcji w menu }
      PiszXY(x,pred(y)+i,s);   { wypisz opcje }
      PiszXY(x,y+LiczbaOpcji,'0: Zaniechanie wyboru')
    end;
  repeat
    Czekaj; { na nacisniecie klawisza }
  until ch in ['0'..OstatniaOpcja]; { wybrano jedna z opcji }
  Menu:=ord(ch) - ord('0') { zwroc numer opcji - znak na cyfre}
end;

function Szlaczek(Zn:char;Dlug:byte):string;

var
  s : string; { miejsce na znaki }
  i : integer; { licznik }

begin
  s:='';         { zeby bylo z czego zaczac }
  for i:=1 to Dlug do
    s:=s+Zn;     { dodawaj kolejne znaki }
  Szlaczek:=s   { zwroc lancuch znakow Zn }
end;

begin { sekcja inicjalizacji }
  PoprzednieKolory:=TextAttr; { na wszelki wypadek }
end. { unit InterfejsUzytkownika }