program TopSecret;

const
  MAXDLUG = 120; { maksymalna dlugosc wiersza }
  MAXNR   = 500; { maks. liczba przetwarzanych wierszy }

type
  Wiersz   = string[MAXDLUG]; { takimi wierszami operujemy}
  Bufor    = array[1..MAXNR] of Wiersz; { bufor na tekst }

var
  Tekst       : Bufor;    { tu bedzie przechowywany tekst }
  IleWierszy  : integer;  { biezaca liczba wierszy w tekscie}
  Klucz       : longint;  { wartosc klucza do (de)szyfrowania}
  Tryb       : byte;    { 1: szyfrowanie, 2: deszyfrowanie }
  i           : integer;  { pomocniczy licznik }

function CzytajTekst(var BuforWej:Bufor):integer;
{ czyta tekst do BuforaWej, zwraca liczbe przeczyt. wierszy }

var
  NazwaPliku  : string;   { nazwa pliku wejsciowego }
  i : integer;           { pomocniczy licznik }
  f : text;               { plik do kodowania }

begin
  write('Podaj nazwe pliku zrodlowego: ');
  readln(NazwaPliku);   { wczytaj nazwe pliku... }
  assign(f,NazwaPliku);
  reset(f);             { ... otworz go }
  i:=0;                 { pierwotna wartosc licznika }
  while not eof(f) do
    begin
      Inc(i);           { kolejny wiersz }
      readln(f,BuforWej[i]); {wczytaj wiersz, do 120 znakow!}
    end;
  close(f);
  CzytajTekst:=i { zwroc liczbe przeczytanych wierszy }
end;

procedure PiszTekst(var BuforWyj:Bufor;IleWierszy:integer);
{ zapisuje IleWierszy z BuforaWyj do pliku tekstowego }

var
  NazwaPliku  : string;   { nazwa pliku wyjsciowego }
  i : integer;           { pomocniczy licznik }
  f : text;               { plik po kodowaniu }

begin
  write('Podaj nazwe pliku docelowego: ');
  readln(NazwaPliku); { jak poprzednio }
  assign(f,NazwaPliku);
  rewrite(f); { utworz plik docelowy lub skasuj stary (!) }
  for i:=1 to IleWierszy do
    writeln(f,BuforWyj[i]); { zapisz wiersze do pliku docel. }
  close(f)
end;

function Szyfruj(s:Wiersz):Wiersz;
{ szyfruje pojedynczy wiersz tekstu }

var
  i : byte; { wystarczy licznik bajtowy ! }

begin
  for i:=1 to Length(s) do   { do wszystkich znakow wiersza }
    s[i]:=chr(ord(s[i])+Random(128)); { dodaj liczbe losowa }
  Szyfruj:=s                { zwroc zaszyfrowany tekst }
end;

function Deszyfruj(s:Wiersz):Wiersz;

var
  i : byte;

begin
  for i:=1 to Length(s) do{ od wszystkich znakow wiersza }
    s[i]:=chr(ord(s[i])-Random(128)); { odejmij liczbe losowa}
  Deszyfruj:=s               { zwroc odszyfrowany tekst }
end;

begin { program }
  write('Podaj wartosc klucza (liczba calkowita): ');
  readln(Klucz);
  RandSeed:=Klucz; {wartosc startowa dla generatora losowego}
  IleWierszy:=CzytajTekst(Tekst);
  repeat { pytaj az do skutku }
    write('Czy chcesz: (1) szyfrowac, (2) deszyfrowac ?');
    readln(Tryb);
  until Tryb in [1,2]; { o tym zaraz }
  if Tryb = 1 then               { szyfrowanie }
    for i:=1 to IleWierszy do     { wszystkich wierszy }
      Tekst[i]:=Szyfruj(Tekst[i])
  else                        { deszyfrowanie }
    for i:=1 to IleWierszy do     { wszystkich wierszy }
      Tekst[i]:=Deszyfruj(Tekst[i]);
  PiszTekst(Tekst,IleWierszy) { zapisz wynik (de)szyfrowania }
end. { program TopSecret}