program Squash;

uses
  Crt,
  InterfejsUzytkownika;

const
  KursorGora       = #72;   { kod klawisza "kursor w gore" }
  KursorDol         = #80;   { i "w dol" - pozostale juz sa }
  LiniaAutowa       = 78;     { linia ruchu rakiety }
  Predkosc         = 10;    { mozna zmieniac od 1 do 200 }
  Punkty : integer  = 0;     { ile wygrales }
  Runda : integer  = 1;      { w ktorej rundzie }

type { definicje klas }
  TZnak = object     { T oznacza Typ }
    x,y : byte;       { polozenie znaku }
    Kod : char;       { jego wyglad }
    constructor Inicjuj(WspX,WspY:byte);                         { tworzenie }
    destructor Koniec;virtual;                                 { zniszczenie }
    procedure Pokaz;virtual;                                  { wyswietlenie }
    procedure Schowaj;virtual;                                   { schowanie }
    procedure Przesun(NowyX,NowyY:byte);                      { przesuniecie }
  end;

TPilka = object(TZnak) { dziedziczy po obiekcie TZnak }
     dx : integer; { nowe pola: pilka sie przemieszcza }
    dy : integer;
    constructor Inicjuj(WspX,WspY:byte);                   { przedefiniowany }
     procedure Steruj;                                   { swoiste dla pilki }
    procedure OdbijOdRakiety;                                { odbicie pilki }
  end;

TRakieta = object(TZnak)
     constructor Inicjuj(WspX,WspY:byte);                    { inicjalizacja }
    procedure Pokaz;virtual;                          { wyswietlenie rakiety }
    procedure Schowaj;virtual;                           { zgaszenie rakiety }
     procedure Steruj;                             { sterowanie z klawiatury }
    function Srodek:byte;                        { podaje wspolrzedna srodka }
  end;

var
  Pilka : TPilka; { realizacja klasy TPilka }
  Rakieta : TRakieta; { realizacja klasy TRakieta }
  i : byte;
  Opoznienie : word; { okresla predkosc ruchu }

{ procedury globalne }

procedure Punktacja;
{ wypisuje wynik }

begin
  GotoXY(1,25); { ostatni wiersz }
  write('Runda:  ',Runda:3,' Punkty: ',Punkty:3,'  Srednio:',
  Punkty/Runda:6:2);
  write('    Esc - koniec.');
end;

procedure KoniecRundy;
{ i ew. start nastepnej rundy }

begin
  Punktacja;
  Pilka.Koniec; { usun pilke }
  Czekaj;
  if ch = Esc then Halt(0);         { koniec programu }
  Inc(Runda);                       { kolejna runda }
  Pilka.Inicjuj(1,Random(20)+2);  { wyrzuc nowa pilke }
end;

{ definicje metod }

constructor TZnak.Inicjuj(WspX,WspY:byte);

begin
  x:=WspX; { odwolania do wlasnych pol obiektu }
  y:=WspY;
  Pokaz { znak na (x,y) }
end;

destructor TZnak.Koniec;

begin
  Schowaj { prosty ! }
end;



procedure TZnak.Pokaz;

begin
  PiszXY(x,y,Kod); { bez... }
end;

procedure TZnak.Schowaj;

begin
  PiszXY(x,y,' '); { ...komentarza }
end;

procedure TZnak.Przesun(NowyX,NowyY:byte);

begin
  Schowaj;    { taka sama sekwencja czynnosci jest }
  x:=NowyX;   { wykonywana przy przemieszczaniu }
  y:=NowyY;   { kazdego obiektu - najlepiej zastosowac }
  Pokaz       { mechanizm metod wirtualnych }
end;

constructor TPilka.Inicjuj(WspX,WspY:byte);

begin
  Kod:=#02; { buzka }
  dx:=1;
  dy:=2*integer(Random(2))-1; { konwersja na integer }
  TZnak.Inicjuj(WspX,WspY);
end;

procedure TPilka.Steruj;

var
  xx,yy : shortint;

begin
  if x = pred(LiniaAutowa) then{ odbicie rakieta ? }
    OdbijOdRakiety;               { wywolanie wlasnej metody }
  yy:=y+dy;
  if (yy < 1) or (yy > 24) then { odbicie od sciany bocznej }
    begin
      Buczek(2000,0.05);
      dy:=-dy   { zmien kierunek w pionie }
    end;
  if x*dx = -1 then   { pilka pada na sciane }
    begin
      Buczek(1000,0.05);
      dx:=-dx   { odbicie od sciany przedniej }
    end;
  xx:=x+dx;    { wspolrzedne po przesunieciu }
  yy:=y+dy;
  Przesun(xx,yy)    { zawsze }
end;



procedure TPilka.OdbijOdRakiety;

var
  Roznica : integer;

begin
  Buczek(500,0.05);
  Roznica:=y - Rakieta.Srodek;
  { miedzy pilka a srodkiem rakiety }
  if abs(Roznica) < 2 then       { touch ! }
    begin
      Inc(Punkty);               { punkt ! }
      dx:=-dx;                   { odbij pilke do sciany }
      if abs(Roznica) = 0 then    { mala zmiana kierunku }
        dy:=integer(2*Random(2)-1) { odbicie srodkiem rakiety}
      else                     { duza zmiana kierunku }
        dy:=Roznica*2*dy         { odbicie krancem rakiety }
    end
  else
    KoniecRundy; { pilka uciekla }
  Punktacja
end;

constructor TRakieta.Inicjuj(WspX,WspY:byte);

begin
  Kod:=#219; { pelny prostokat }
  TZnak.Inicjuj(WspX,WspY);
end;

procedure TRakieta.Pokaz;

var
  i : byte;

begin { uwaga : metoda przedefiniowana }
  for i:=0 to 2 do
    PiszXY(x,y+i,Kod);
end;

procedure TRakieta.Schowaj;

var
  StaryKod : char;

begin           { tez przedefiniowana }
  StaryKod:=Kod;  { zapamietaj kod znaku }
  Kod:=' ';       { mala sztuczka }
  Pokaz;         { wyswietl spacje }
  Kod:=StaryKod   { odtworz kod znaku }
end;

procedure TRakieta.Steruj;

var
  yy : byte;

begin
  Delay(Opoznienie); { odczekaj jakis czas }
  if KeyPressed then { jesli gracz nacisnal klawisz }
    begin
      yy:=y;
      Czekaj; { pobierz kod klawisza }
        case ch of { w gore lub w dol }
            KursorGora : if y > 1 then Dec(yy);
            KursorDol  : if y < 22 then Inc(yy);
          end;
      Przesun(x,yy) { i przesun rakiete }
    end
end;

function TRakieta.Srodek:byte;

begin
  Srodek:=succ(y) { wspolrzedna y = gorny koniec }
end;


begin { program }
  ClrScr;               { pozamiataj kort }
  Opoznienie:=200 div Predkosc;
  Punktacja;           { wypisz wynik }
  Rakieta.Inicjuj(LiniaAutowa,10); { inicjuj pola i odwolania}
  Pilka.Inicjuj(1,10); { do metod wirtualnych pilki i rakiety}
  repeat
    ch :=#0;           { dla bezpieczenstwa }
    repeat
      for i:=1 to 4 do
        Rakieta.Steruj; { daj czas graczowi }
      Pilka.Steruj;     { przesun pilke }
    until ch = Esc;
  until ch = Esc;       { wyjscie w trakcie gry }
end. { program Squash }