program Lista;
{ demonstracja obslugi listy jednokierunkowej }

uses Crt;

type
  Wskaznik = ^Element; { wskaznik do elementu listy }
  Element = record           { element listy }
              Tekst : string; { jego zawartosc }
              Wsk : Wskaznik  { wskaznik do nastepnego }
            end;

const
  Glowa : Wskaznik = nil; { tworzymy od razu pusta liste }

procedure Inicjalizuj;

begin
  Glowa:=nil
end;

procedure UtworzElement(s:string;Poprzedni:Wskaznik);
{ tworzy element listy nie bedacy glowa }

var
  Nowy : Wskaznik;

begin
  new(Nowy);                 { utworz element }
  Nowy^.Tekst:=s;             { wpisz jego tresc }
  Nowy^.Wsk:=Poprzedni^.Wsk;  { ustaw wskaznik nowego elem. }
  Poprzedni^.Wsk:=Nowy       { dolacz go do listy }
end;


procedure UtworzGlowe(s:string);
{ tworzy glowe nieistniejacej listy }

begin
  new(Glowa);       { utworz glowe }
  Glowa^.Tekst:=s;  { wpisz tekst do glowy }
  Glowa^.Wsk:=nil;  { zakoncz liste na 1. elemencie }
end;

function Szukaj(s:string):Wskaznik;
{ zwraca wskaznik do elementu listy zawierajacego lancuch s }
{ lub nil, jesli nie znaleziono lancucha }

var
  Pomoc : Wskaznik;

begin
  Pomoc:=Glowa;               { zacznij od poczatku listy }
  while (Pomoc^.Wsk <> nil)   { koniec listy ? }
  and (Pomoc^.Tekst <> s) do  { znaleziono lancuch ? }
    Pomoc:=Pomoc^.Wsk;       { skocz do nastepnego elementu }
  Szukaj:=Pomoc
end;

procedure Wstaw(s:string;Po:string);
{ wstawia element o zawartosci s po elemencie
{ zawierajacym lancuch Po }

var
  Pomoc,Nowy : Wskaznik;
  i : integer;

begin
  if Glowa = nil then { lista nie istnieje }
    UtworzGlowe(s)
  else { znajdz miejsce wstawienia i wstaw element }
    UtworzElement(s,Szukaj(Po)); { ! }
end;

procedure Dopisz(s:string);
{ dopisuje element o zawartosci s na koncu listy }

var
  Pomoc,Nowy : Wskaznik;

begin
  Wstaw(s,''); { znajdz koniec listy i wstaw tam element }
end;

procedure Usun(s:string);
{ usuwa z listy element zawierajacy lancuch s }

var
  Pomoc : Wskaznik;
  i : integer;

begin
  if Glowa^.Tekst = s then
    begin
      dispose(Glowa);   { zwolnij pamiec }
      Glowa:=Glowa^.Wsk { nowa glowa = element 2 }
    end
  else { usuwamy element 2...ostatni }
    begin
      Pomoc:=Glowa; { zaczynamy od poczatku listy }
      while (Pomoc^.Wsk <> nil) and { znajdz element }
      (Pomoc^.Wsk^.Tekst <> s) do   { poprzedzajacy szukany}
        Pomoc:=Pomoc^.Wsk;
      dispose(Pomoc^.Wsk);         { usun element }
      Pomoc^.Wsk:=Pomoc^.Wsk^.Wsk;  {przeskocz puste miejsce}
    end
end;

procedure WypiszListe;
{ wypisuje cala zawartosc listy }

var
  Pomoc : Wskaznik;

begin
  Pomoc:=Glowa; { wypisujemy od poczatku }
  writeln('Zawartosc listy: ');
  while Pomoc <> nil do
    begin
      writeln(Pomoc^.Tekst); { nastepny element }
      Pomoc:=Pomoc^.Wsk      { wypisz go }
    end;
  writeln;
end;

begin { program }
  ClrScr;
  Dopisz('To jest pierwszy lancuch'); { dopisz kilka tekstow }
  WypiszListe;
  Dopisz('A to drugi lancuch');
  WypiszListe;
  Wstaw('Ten lancuch wstawiono po drugim',
        'A to drugi lancuch');
  WypiszListe;
  Dopisz('To jest ostatni, trzeci lancuch');
  WypiszListe;
  Usun('To jest ostatni, trzeci lancuch');
  WypiszListe;
  { na koniec warto by jeszcze posprzatac pamiec! }
end. { program Lista }