USE AdventureWorks
GO

INSERT INTO HumanResources.Department
VALUES ('XYZ','ABC');

INSERT INTO HumanResources.Department (Name,GroupName)
VALUES ('XYZ','ABC');

SELECT *
FROM HumanResources.Department
WHERE Name = 'XYZ';

INSERT INTO HumanResources.Department (DepartmentID,Name,GroupName)
VALUES (20,'ZYX','CBA');

INSERT INTO HumanResources.Department (Name,GroupName,ModifiedDate)
VALUES ('ZYX','CBA','2010-10-10');

SELECT *
FROM HumanResources.Department
WHERE Name = 'ZYX';

INSERT INTO HumanResources.Department (Name,GroupName,ModifiedDate)
VALUES ('ZZZ','AAA',DEFAULT);

SELECT *
FROM HumanResources.Department
WHERE Name = 'ZZZ';

INSERT INTO Production.ProductPhoto (LargePhotoFileName)
VALUES ('MojeZdjecie');

SELECT *
FROM Production.ProductPhoto
WHERE LargePhotoFileName='MojeZdjecie';

INSERT INTO Production.ProductPhoto (ThumbNailPhoto,ThumbnailPhotoFileName,LargePhoto,LargePhotoFileName,ModifiedDate)
VALUES (NULL,NULL,NULL,'Zdjecie1',DEFAULT);

INSERT INTO HumanResources.Department (Name, GroupName,ModifiedDate)
VALUES ('XXX',NULL,DEFAULT);

INSERT INTO HumanResources.Department (Name, GroupName,ModifiedDate)
VALUES ('N01','G01',DEFAULT),('N02','G02',DEFAULT);

SELECT *
INTO #ProdK1
FROM Production.Product
WHERE ProductSubcategoryID=1;

SELECT Name,ProductNumber,ListPrice *1.15 AS Cena
INTO #ProdK2
FROM Production.Product
WHERE ProductSubcategoryID=2;

SELECT ProductID,Name,ListPrice,Color
INTO #ProdPuste
FROM Production.Product
WHERE 1<>1;

INSERT INTO #ProdPuste
SELECT ProductID,Name,ListPrice,Color
FROM Production.Product
WHERE ProductSubcategoryID <3;

INSERT INTO #ProdPuste (Name,ListPrice)
SELECT Name,ListPrice
FROM Production.Product
WHERE ProductSubcategoryID <3;

INSERT INTO #ProdPuste (Name,ListPrice,Color)
SELECT Name,ListPrice,Color
FROM Production.Product AS P
WHERE NOT EXISTS
  (SELECT *
  FROM #ProdPuste AS O
  WHERE O.Name = P.Name);
  
DELETE FROM #ProdK1;

DELETE FROM #ProdK2
WHERE Cena <1000;

DELETE P
FROM Production.Product P
JOIN Production.ProductSubcategory SC
ON P.ProductSubcategoryID = SC.ProductSubcategoryID
AND SC.Name = 'Road Bikes';

INSERT INTO #ProdPuste (Name,ListPrice)
SELECT Name,ListPrice
FROM Production.Product
WHERE ProductSubcategoryID <3;

WITH Duplikaty AS
(SELECT *, ROW_NUMBER() OVER(PARTITION BY Name ORDER BY ProductID) AS Liczba
FROM #ProdPuste)
SELECT * FROM Duplikaty
WHERE Liczba>1;

WITH Duplikaty AS
(SELECT *, ROW_NUMBER() OVER(PARTITION BY Name ORDER BY ProductID) AS Liczba
FROM #ProdPuste)
DELETE FROM Duplikaty
WHERE Liczba >1;

TRUNCATE TABLE #ProdPuste;

UPDATE Production.Illustration
SET ModifiedDate = '20101010';

UPDATE Production.Product
SET StandardCost = 10
WHERE SafetyStockLevel <100;

UPDATE Person.Address
SET City = 'Alexandria', AddressLine1 = '99 - 6 Orion Road'
WHERE AddressID=1;

UPDATE Production.Product
SET StandardCost = StandardCost+5
WHERE Color = 'Black';

UPDATE Production.Product
SET StandardCost /= 2
WHERE Color = 'White';

UPDATE P 
SET ListPrice *= 0.75,
DiscontinuedDate = GETDATE()+7
FROM Production.Product AS P JOIN Purchasing.ProductVendor AS V
ON P.ProductID = V.ProductID
WHERE VendorID = 8;

UPDATE A
SET PostalCode = S.StateProvinceCode + ' ' + PostalCode,
AddressLine2 = AddressLine2 + ' ' + S.Name
FROM Person.Address A JOIN Person.StateProvince S
ON A.StateProvinceID = S.StateProvinceID
WHERE TerritoryID=1;

CREATE TABLE #Osoby (ID int identity(1,1), Imie varchar(100));
GO
MERGE INTO #Osoby
USING (Values ('Danuta',1),('Marcin',2)) Znajomi(Imie,Numer)
ON #Osoby.ID = Znajomi.Numer
WHEN NOT MATCHED THEN
INSERT (imie) values (Znajomi.Imie);
SELECT * FROM #Osoby;

MERGE INTO #Osoby
USING (Values ('Krzys',3),('Michal',2)) Znajomi(Imie,Numer)
ON #Osoby.ID = Znajomi.Numer
WHEN MATCHED THEN 
  UPDATE SET #Osoby.Imie = Znajomi.Imie
WHEN NOT MATCHED THEN
  INSERT (imie) values (Znajomi.Imie);
SELECT * FROM #Osoby;

MERGE INTO #Osoby
USING (Values ('Danuta',1),('Marcin',2)) Znajomi(Imie,Numer)
ON #Osoby.ID = Znajomi.Numer
WHEN MATCHED THEN 
UPDATE SET #Osoby.Imie = Znajomi.Imie
WHEN NOT MATCHED THEN
INSERT (imie) values (Znajomi.Imie)
WHEN SOURCE NOT MATCHED THEN
DELETE;
SELECT * FROM #Osoby;
