SELECT 123 + 654, UPPER('sql');
GO

USE AdventureWorks;
SELECT DepartmentID, Name
FROM HumanResources.Department;
GO

SELECT DepartmentID, Name
FROM AdventureWorks.HumanResources.Department;
GO

SELECT DepartmentID, Name
FROM Department;
GO

SELECT Name,ShiftID
FROM HumanResources.Shift;
GO

SELECT ShiftID, Name
FROM HumanResources.Shift;
GO

SELECT *
FROM HumanResources.Shift;
GO

SELECT ReviewerName, ProductID
FROM Production.ProductReview;
GO

SELECT ProductID
FROM Production.ProductReview;
GO

SELECT ALL ProductID
FROM Production.ProductReview;
GO

SELECT DISTINCT ProductID
FROM Production.ProductReview;
GO

SELECT DISTINCT ProductID, ReviewerName
FROM Production.ProductReview;
GO

SELECT Quantity, Quantity*5
FROM Sales.ShoppingCartItem;
GO

SELECT ShipBase, ShipRate, ShipBase*ShipRate
FROM Purchasing.ShipMethod;
GO

SELECT ShipBase+ShipBase*ShipRate, (ShipBase+ShipBase)*ShipRate
FROM Purchasing.ShipMethod;
GO

SELECT Title, FileExtension, Title+FileExtension
FROM Production.Document;
GO

SELECT DATEDIFF (HOUR,'20070101','20071231');
GO

SELECT '1'+1+'1', '1'+'1'+1;
GO

SELECT ShoppingCartID + '-' + CAST(Quantity AS VARCHAR(10))
FROM Sales.ShoppingCartItem;
GO

SELECT Quantity, 
  CASE
         WHEN Quantity<4 THEN 'Mao'
         WHEN Quantity<7 THEN 'rednio'
         ELSE 'Duo'
  END 
FROM Sales.ShoppingCartItem;
GO

SELECT ShipBase AS Podstawa, ShipBase*ShipRate AS Calkowita
FROM Purchasing.ShipMethod;
GO

SELECT ShipBase 
FROM Purchasing.ShipMethod AS SM;
GO

SELECT Purchasing.ShipMethod.ShipBase 
FROM Purchasing.ShipMethod AS SM;
GO

SELECT SM.ShipBase 
FROM Purchasing.ShipMethod AS SM;
GO

SELECT 'Zmiana ' + Name, 'zaczyna si o ', DATEPART(HOUR, StartTime)
FROM HumanResources.Shift;
GO

SELECT ProductReviewID, GETDATE(), RAND()
FROM Production.ProductReview;
GO

SELECT ShiftID, StartTime
FROM HumanResources.Shift
ORDER BY ShiftID;

SELECT ShiftID, StartTime
FROM HumanResources.Shift
ORDER BY 1;
GO

SELECT ShiftID, StartTime
FROM HumanResources.Shift
ORDER BY 2 DESC;
GO

SELECT ProductID, ReviewerName
FROM Production.ProductReview
ORDER BY ProductID ASC, ReviewerName DESC;
GO

SELECT ReviewerName
FROM Production.ProductReview
ORDER BY ProductID;
GO

SELECT SalesOrderID, ProductID, LineTotal
FROM Sales.SalesOrderDetail;

SELECT SalesOrderID, ProductID, LineTotal
FROM Sales.SalesOrderDetail
ORDER BY ProductID;
GO

UPDATE Production.ProductReview
SET EmailAddress = 'John@fourthcoffee.com'
WHERE ProductReviewID=1;
GO

SELECT EmailAddress
FROM Production.ProductReview
ORDER BY EmailAddress;

SELECT EmailAddress
FROM Production.ProductReview
ORDER BY EmailAddress COLLATE Polish_BIN;
GO