USE AdventureWorks 
GO

SELECT ProductSubcategoryID, Name
FROM Production.Product
WHERE ListPrice BETWEEN 500 AND 550;

SELECT ProductSubcategory.Name, Product.Name
FROM Production.Product JOIN Production.ProductSubcategory
ON Production.Product.ProductSubcategoryID = Production.ProductSubcategory.ProductSubcategoryID
WHERE Product.ListPrice BETWEEN 500 AND 540;

SELECT ProductSubcategory.Name, Product.Name
FROM Production.Product, Production.ProductSubcategory
WHERE Production.Product.ProductSubcategoryID = Production.ProductSubcategory.ProductSubcategoryID
AND Product.ListPrice BETWEEN 500 AND 540;

SELECT Name
FROM Production.Product JOIN Sales.SalesOrderDetail
ON Production.Product.ProductID = Sales.SalesOrderDetail.ProductID
WHERE SalesOrderID = 43665;

SELECT Name
FROM Production.Product JOIN Production.ProductSubcategory
ON Production.Product.ProductSubcategoryID = Production.ProductSubcategory.ProductSubcategoryID
WHERE ListPrice BETWEEN 500 AND 540;

SELECT PS.Name, P.Name
FROM Production.Product AS P JOIN Production.ProductSubcategory AS PS
ON P.ProductSubcategoryID = PS.ProductSubcategoryID
WHERE P.ListPrice BETWEEN 500 AND 540;

SELECT PS.Name, P.Name, PS.ProductSubcategoryID, P.ProductID
FROM Production.Product AS P JOIN Production.ProductSubcategory AS PS
ON P.ProductID = PS.ProductSubcategoryID;

SELECT P.Name, P.ListPrice
FROM Production.Product AS P JOIN Sales.SalesOrderDetail AS OD
ON P.ListPrice > OD.LineTotal;

SELECT P.Name, P.ListPrice
FROM Production.Product AS P JOIN Sales.SalesOrderDetail AS OD
ON P.ListPrice > OD.LineTotal AND P.ProductID=OD.ProductID;

INSERT INTO Production.ProductCategory (Name)
VALUES ('AAA');

SELECT C.Name,SC.Name
FROM Production.ProductCategory AS C JOIN Production.ProductSubcategory AS SC
ON C.ProductCategoryID=SC.ProductCategoryID
ORDER BY C.Name;

SELECT C.Name,SC.Name
FROM Production.ProductCategory AS C INNER JOIN Production.ProductSubcategory AS SC
ON C.ProductCategoryID=SC.ProductCategoryID
ORDER BY C.Name;

SELECT C.Name,SC.Name
FROM Production.ProductCategory AS C LEFT OUTER JOIN Production.ProductSubcategory AS SC
ON C.ProductCategoryID=SC.ProductCategoryID
ORDER BY C.Name; 

SELECT C.Name,SC.Name
FROM Production.ProductSubcategory AS SC RIGHT OUTER JOIN Production.ProductCategory AS C
ON C.ProductCategoryID=SC.ProductCategoryID
WHERE SC.Name IS NULL;

INSERT INTO Production.ProductSubcategory (ProductCategoryID, Name)
VALUES (NULL,'XYZ');

SELECT C.Name,SC.Name
FROM Production.ProductSubcategory AS SC FULL OUTER JOIN Production.ProductCategory AS C
ON C.ProductCategoryID=SC.ProductCategoryID
WHERE SC.Name IS NULL OR C.Name IS NULL;

SELECT C.Name, S.Name
FROM Production.ProductCategory AS C CROSS JOIN HumanResources.Shift AS S;

SELECT DISTINCT C.Name, S.Name
FROM Production.ProductCategory AS C CROSS JOIN HumanResources.Shift AS S;

SELECT EmployeeID, Name, ProductID
FROM HumanResources.Employee, Production.Product;

SELECT LastName, FirstName
FROM Person.Contact;

SELECT P.LastName, P.FirstName
FROM Person.Contact AS P JOIN HumanResources.Employee AS E
ON P.ContactID = E.ContactID;

SELECT P.LastName, P.FirstName, A.City
FROM Person.Contact AS P JOIN HumanResources.Employee AS E
ON P.ContactID = E.ContactID
JOIN HumanResources.EmployeeAddress AS EA 
ON EA.EmployeeID = E.EmployeeID
JOIN Person.Address AS A 
ON A.AddressID = EA.AddressID
ORDER BY P.LastName;

SET SHOWPLAN_TEXT ON;
GO
SELECT P.LastName, P.FirstName, A.City
FROM Person.Contact AS P JOIN HumanResources.Employee AS E
ON P.ContactID = E.ContactID
JOIN HumanResources.EmployeeAddress AS EA 
ON EA.EmployeeID = E.EmployeeID
JOIN Person.Address AS A 
ON A.AddressID = EA.AddressID
ORDER BY P.LastName;
GO
SET SHOWPLAN_TEXT OFF;

INSERT INTO HumanResources.Department (Name,GroupName)
VALUES ('Testing','Quality Assurance');

SELECT D.Name, D. GroupName, H.EmployeeID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
ORDER BY H.EmployeeID;

SELECT D.Name, D.GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
INNER JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID
ORDER BY H.EmployeeID;

SELECT D.Name, D.GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN HumanResources.EmployeeDepartmentHistory H
ON D.DepartmentID = H.DepartmentID
LEFT JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID
ORDER BY H.EmployeeID;

SELECT D.Name, D.GroupName, H.EmployeeID, LoginID
FROM HumanResources.Department D LEFT JOIN 
(HumanResources.EmployeeDepartmentHistory H
INNER JOIN HumanResources.Employee EA
ON EA.EmployeeID = H.EmployeeID)
ON D.DepartmentID = H.DepartmentID
ORDER BY H.EmployeeID;

SELECT Name
FROM HumanResources.Shift CROSS JOIN HumanResources.Shift;

SELECT Name
FROM HumanResources.Shift AS T1 CROSS JOIN HumanResources.Shift AS T2;

SELECT T1.Name
FROM HumanResources.Shift AS T1 CROSS JOIN HumanResources.Shift AS T2;

SELECT T1.Name, T2.Name, T1.ListPrice
FROM Production.Product AS T1 JOIN Production.Product AS T2
ON T1.ListPrice = T2.ListPrice
WHERE T1.ListPrice >3000;

SELECT DISTINCT T1.Name, T2.Name, T1.ListPrice
FROM Production.Product AS T1 JOIN Production.Product AS T2
ON T1.ListPrice = T2.ListPrice
WHERE T1.ListPrice >3000;

SELECT T1.Name, T2.Name, T1.ListPrice
FROM Production.Product AS T1 JOIN Production.Product AS T2
ON T1.ListPrice = T2.ListPrice
AND T1.Name <T2.Name
WHERE T1.ListPrice >3000; 

SELECT T1.EmployeeID, T2.EmployeeID, T1.ManagerID, T2.ManagerID
FROM HumanResources.Employee T1 JOIN HumanResources.Employee T2
ON T1.ManagerID = T2.EmployeeID
WHERE T1.ManagerID=109;

SELECT Name
FROM Purchasing.Vendor
WHERE Name LIKE 'T%'
UNION 
SELECT Name
FROM Sales.Store
WHERE Name LIKE 'We%';

SELECT Name
FROM Purchasing.Vendor
ORDER BY Name
UNION 
SELECT Name
FROM Sales.Store
ORDER BY Name;

SELECT GroupName, Name
FROM HumanResources.Department
WHERE Name LIKE 'T%'
UNION 
SELECT Name, AccountNumber
FROM Purchasing.Vendor
WHERE Name LIKE 'T%'
ORDER BY 1;

SELECT ShiftID
FROM HumanResources.Shift
UNION 
SELECT AddressTypeID
FROM Person.AddressType;

SELECT ShiftID
FROM HumanResources.Shift
UNION ALL
SELECT AddressTypeID
FROM Person.AddressType;

SELECT SalesOrderNumber, CustomerID
FROM Sales.SalesOrderHeader
WHERE SalesOrderNumber LIKE 'SO5000%'
OR CustomerID IN (29385, 29410);

SELECT SalesOrderNumber, CustomerID
FROM Sales.SalesOrderHeader
WHERE SalesOrderNumber LIKE 'SO5000%'
UNION ALL
SELECT SalesOrderNumber, CustomerID
FROM Sales.SalesOrderHeader
WHERE CustomerID=29385
UNION ALL
SELECT SalesOrderNumber, CustomerID
FROM Sales.SalesOrderHeader
WHERE CustomerID=29410;

SELECT ProductID
FROM Production.Product
INTERSECT 
SELECT ProductID
FROM Production.ProductListPriceHistory;

SELECT ProductID
FROM Production.Product
EXCEPT 
SELECT ProductID
FROM Production.ProductListPriceHistory;

SELECT EmployeeID, FirstName, AddressLine1
FROM HumanResources.vEmployee
WHERE CountryRegionName = 'Canada';

SELECT * 
FROM dbo.ufnGetContactInformation(1);

SELECT E.EmployeeID, F.FirstName, F.JobTitle
FROM HumanResources.Employee AS E
CROSS APPLY dbo.ufnGetContactInformation(ContactID) AS F
WHERE E. Gender = 'F'
AND E.BirthDate >'19800101'
GO

CREATE FUNCTION udfOstatnieZamowienia(@custid AS INT, @n AS INT)
RETURNS TABLE
AS RETURN
SELECT TOP(@n) SalesOrderID,OrderDate,CustomerID,TotalDue
FROM Sales.SalesOrderHeader
WHERE CustomerID = @custid
ORDER BY OrderDate DESC;
GO

SELECT *
FROM dbo.udfOstatnieZamowienia(280,5);

SELECT C.Name, F.OrderDate, F.CustomerID, F.TotalDue
FROM Sales.Store AS C
CROSS APPLY udfOstatnieZamowienia(C.CustomerID, 2) AS F
WHERE F.TotalDue >140000
ORDER BY F.Orderdate;

SELECT C.Name, F.*
FROM Sales.Store AS C
CROSS APPLY udfOstatnieZamowienia(C.CustomerID, 1) AS F
WHERE F.CustomerID IS NULL;

SELECT C.name, F.*
FROM Sales.Store AS C
OUTER APPLY udfOstatnieZamowienia(C.CustomerID, 1) AS F
WHERE F.CustomerID IS NULL;

