USE AdventureWorks
GO

SELECT ProductSubcategoryID
FROM Production.Product 
WHERE Name = 'Road-150 Red, 44';

SELECT Name
FROM Production.ProductSubcategory 
WHERE ProductSubcategoryID=2;

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID = 
(SELECT P.ProductSubcategoryID
FROM Production.Product AS P
WHERE P.Name = 'Road-150 Red, 44');

SELECT AVG(ListPrice) 
FROM Production.Product; 

SELECT Name, ListPrice, '438,6662'
FROM Production.Product; 

SELECT Name, ListPrice, 
  (SELECT AVG(ListPrice) 
  FROM Production.Product)
FROM Production.Product; 

SELECT Name, ListPrice, 
  (SELECT AVG(ListPrice) 
  FROM Production.Product),
  ListPrice - (SELECT AVG(ListPrice) 
            FROM Production.Product)
FROM Production.Product;

SELECT Z.Name
FROM Production.Product AS Z
WHERE Z.ListPrice = 
	(SELECT W.ListPrice + 112.565
	FROM Production.Product AS W
	WHERE W.ProductID=1); 

SELECT ProductSubcategoryID
FROM Production.Product
WHERE Name LIKE 'Road-150 Red%'; 

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID = 
	(SELECT P.ProductSubcategoryID
	FROM Production.Product AS P
	WHERE P.Name LIKE 'Road-150 Red%'); 

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID IN 
	(SELECT P.ProductSubcategoryID
	FROM Production.Product AS P
	WHERE P.Name LIKE 'Road-150 Red%'); 

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID IN 
(SELECT P.ProductSubcategoryID
FROM Production.Product AS P
WHERE P.Name LIKE 'A%'); 

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID IN 
(SELECT P.ProductSubcategoryID
FROM Production.Product AS P
WHERE P.Name = 'XYZ'); 

SELECT SC.Name
FROM Production.ProductSubcategory AS SC
WHERE SC.ProductSubcategoryID = 
(SELECT P.ProductSubcategoryID
FROM Production.Product AS P
WHERE P.Name = 'XYZ'); 

SELECT C.LastName, C.FirstName 
FROM Person.Contact C JOIN HumanResources.Employee E 
ON E.ContactID = C.ContactID 
WHERE EmployeeID IN 
  (SELECT SalesPersonID 
  FROM Sales.SalesOrderHeader 
  WHERE SalesOrderID IN 
         (SELECT SalesOrderID 
         FROM Sales.SalesOrderDetail
         WHERE ProductID = 
                 (SELECT ProductID 
                 FROM Production.Product P 
                 WHERE P.Name = 'Road-150 Red, 56'))); 

SELECT S.SalesPersonID, S.TerritoryID
FROM Sales.SalesPerson AS S
JOIN Sales.SalesOrderHeader AS OH
ON S.SalesPersonID=OH.SalesPersonID
WHERE OH.OrderDate = '2004-03-31';

SELECT S.SalesPersonID, S.TerritoryID
FROM Sales.SalesPerson AS S
WHERE '2004-03-31' IN
  (SELECT OH.OrderDate
  FROM Sales.SalesOrderHeader AS OH
  WHERE S.SalesPersonID=OH.SalesPersonID);

SELECT Z.Title, Z.EmployeeID, Z.VacationHours
FROM HumanResources.Employee AS Z
WHERE Z.VacationHours = 
(SELECT MAX(W.VacationHours)
FROM HumanResources.Employee AS W);

SELECT Z.Title, Z.EmployeeID, Z.VacationHours
FROM HumanResources.Employee AS Z
WHERE Z.VacationHours = 
  (SELECT MAX(W.VacationHours)
  FROM HumanResources.Employee AS W
  WHERE W.VacationHours <
         (SELECT MAX(W2.VacationHours)
         FROM HumanResources.Employee AS W2));

SELECT COUNT(DISTINCT(S2.VacationHours))
FROM HumanResources.Employee S2
WHERE S2.VacationHours > 98;

SELECT Z.Title, Z.EmployeeID, Z.VacationHours
FROM HumanResources.Employee AS Z
WHERE 1 = 
(SELECT COUNT(DISTINCT(W.VacationHours))
FROM HumanResources.Employee AS W
WHERE W.VacationHours >Z.VacationHours);

SELECT Z.SalesOrderID,Z.SalesPersonID, Z.TotalDue,Z.OrderDate
FROM Sales.SalesOrderHeader AS Z
WHERE Z.TotalDue = 
  (SELECT MAX(W.TotalDue)
  FROM Sales.SalesOrderHeader AS W
  WHERE Z.OrderDate=W.OrderDate)
AND Z.SalesPersonID IS NOT NULL
AND Z.OrderDate <'20020101';

SELECT Z.SalesOrderID,Z.SalesPersonID, Z.TotalDue, 'Najwicej w dniu:',Z.OrderDate
FROM Sales.SalesOrderHeader AS Z
WHERE Z.TotalDue = 
  (SELECT MAX(W.TotalDue)
  FROM Sales.SalesOrderHeader AS W
  WHERE Z.OrderDate=W.OrderDate)
AND Z.SalesPersonID IS NOT NULL
AND Z.OrderDate <'20020101'
UNION
SELECT Z.SalesOrderID,Z.SalesPersonID, Z.TotalDue, 'Najmniej w dniu:',Z.OrderDate
FROM Sales.SalesOrderHeader AS Z
WHERE Z.TotalDue = 
  (SELECT MIN(W.TotalDue)
  FROM Sales.SalesOrderHeader AS W
  WHERE Z.OrderDate=W.OrderDate)
AND Z.SalesPersonID IS NOT NULL
AND Z.OrderDate <'20020101';

SELECT Z.SalesPersonID,Z.TerritoryID,Z.SalesOrderID
FROM Sales.SalesOrderHeader AS Z
WHERE NOT Z.TerritoryID = 
  (SELECT W.TerritoryID
  FROM Sales.SalesPerson AS W
  WHERE W.SalesPersonID=Z.SalesPersonID);

SELECT Z.SalesPersonID,Z.TerritoryID,W.TerritoryID,Z.SalesOrderID
FROM Sales.SalesOrderHeader AS Z
WHERE NOT Z.TerritoryID = 
  (SELECT W.TerritoryID
  FROM Sales.SalesPerson AS W
  WHERE W.SalesPersonID=Z.SalesPersonID);

SELECT Z.SalesOrderID, Z.CustomerID,Z.TotalDue
FROM Sales.SalesOrderHeader AS Z
WHERE TotalDue >
  (SELECT AVG(W.TotalDue) *5
  FROM Sales.SalesOrderHeader AS W
  WHERE Z.CustomerID=W.CustomerID)
ORDER BY Z.TotalDue DESC;

SELECT Name, ProductNumber, Color, ListPrice
FROM Production.Product
WHERE Color IS NOT NULL 
AND ListPrice BETWEEN 3000 AND 3500;

SELECT W.Name, W.Color, W.ListPrice
FROM
  (SELECT Name, ProductNumber, Color, ListPrice
  FROM Production.Product
  WHERE Color IS NOT NULL 
  AND ListPrice BETWEEN 3000 AND 3500) AS W
WHERE Color = 'Black';

SELECT 'Pe: '+ Gender AS Pe, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM HumanResources.Employee
WHERE 'Pe: '+ Gender = 'Pe: F'
GROUP BY Gender, DATEDIFF(YY, BirthDate, GETDATE());

SELECT 'Pe: '+ Gender AS Pe, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM HumanResources.Employee
WHERE Pe = 'Pe: F'
GROUP BY Gender, Wiek;

SELECT Pe, Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM
  (SELECT 'Pe: '+ Gender AS Pe, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, EmployeeID
  FROM HumanResources.Employee) AS W
WHERE Pe = 'Pe: F'
GROUP BY Pe, Wiek;

SELECT TotalDue, SalesOrderID, OrderDate,
ROW_NUMBER() OVER(ORDER BY TotalDue DESC) AS Numer
FROM Sales.SalesOrderHeader;

SELECT *
FROM 
  (SELECT TotalDue, SalesOrderID,OrderDate,
  ROW_NUMBER() OVER(ORDER BY TotalDue DESC) AS Numer
  FROM Sales.SalesOrderHeader) AS W
WHERE Numer BETWEEN 11 AND 15;

WITH CTE1 AS
(SELECT 'Pe: '+ Gender AS Pe, DATEDIFF(YY, BirthDate, GETDATE()) AS Wiek, EmployeeID
FROM HumanResources.Employee)
SELECT Pe, Wiek, COUNT(EmployeeID) AS LiczbaPracownikw
FROM CTE1
WHERE Pe = 'Pe: F'
GROUP BY Pe, Wiek;

SELECT TotalDue, NTILE(5) OVER(ORDER BY TotalDue DESC) AS Sprzedaz
FROM Sales.SalesOrderHeader;

WITH przedzialy AS 
(SELECT TotalDue, NTILE(5) OVER(ORDER BY TotalDue DESC) AS Sprzedaz
FROM Sales.SalesOrderHeader)
SELECT Sprzedaz, MIN(TotalDue), MAX(TotalDue), AVG(TotalDue)
FROM przedzialy
GROUP BY Sprzedaz
ORDER BY Sprzedaz;

WITH lata AS
(SELECT CustomerID, TotalDue, YEAR(OrderDate) AS Rok
FROM Sales.SalesOrderHeader),
sumy AS
(SELECT CustomerID, Rok, SUM(TotalDue) AS Suma
FROM lata
GROUP BY CustomerID, Rok)
SELECT TOP 5 *
FROM sumy
ORDER BY Suma DESC;

SELECT SalesOrderID,TotalDue
FROM Sales.SalesOrderHeader
WHERE NTILE(5) OVER(ORDER BY TotalDue DESC) = 1;

WITH podzial AS 
(SELECT SalesOrderID,TotalDue, NTILE(5) OVER(ORDER BY TotalDue DESC) AS Sprzedaz
FROM Sales.SalesOrderHeader)
SELECT SalesOrderID,TotalDue
FROM podzial
WHERE Sprzedaz = 1;

WITH BezposredniPodwladni(ManagerID, Podwladni) AS 
(SELECT ManagerID, COUNT(*)
FROM HumanResources.Employee  
WHERE ManagerID IS NOT NULL 
GROUP BY ManagerID)
SELECT *
FROM BezposredniPodwladni 
ORDER BY ManagerID;

WITH Podwadni AS
(SELECT ManagerID, EmployeeID, 1 as Pozycja
FROM HumanResources.Employee
WHERE ManagerID IS NULL
UNION ALL
SELECT E.ManagerID, E.EmployeeID, P.Pozycja+1
FROM HumanResources.Employee AS E
INNER JOIN Podwadni  AS P ON
E.ManagerID = P.EmployeeID )
SELECT * FROM Podwadni
ORDER BY ManagerID;

WITH Generator AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM Generator 
WHERE i < 5000 )
SELECT i
FROM Generator
ORDER BY i; 

WITH Generator AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM Generator 
WHERE i < 100 )
SELECT i
FROM Generator
ORDER BY i;
GO

CREATE TABLE #SprzedazRoczna(
rok CHAR(4),
sprzedaz INT);
INSERT INTO #SprzedazRoczna (rok,sprzedaz)
VALUES('2001',100),('2002',150),('2003',120),('2004',150),('2005',250),('2006',300),('2007',250);
GO

SELECT Z.rok, Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok)) AS Trend
FROM #SprzedazRoczna AS Z;

SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z;

WITH Lata AS
(SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z)
SELECT MIN(rok), MAX(rok),Trend
FROM Lata
GROUP BY Trend;

WITH Lata AS(
SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z)
SELECT *,(SELECT COUNT(*)
         FROM Lata AS T2
         WHERE T2.rok >= T1.rok AND T2.trend <> T1.trend) AS LiczbaWierszy
FROM Lata AS T1;

WITH Lata AS(
SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z),
Czynnik AS (
SELECT *,(SELECT COUNT(*)
         FROM Lata AS T2
         WHERE T2.rok >= T1.rok AND T2.trend <> T1.trend) AS LiczbaWierszy
FROM Lata AS T1)
SELECT MIN(rok), MAX(rok),Trend
FROM Czynnik
GROUP BY LiczbaWierszy,Trend
ORDER BY MIN(rok);

SELECT OrderDate, TotalDue
FROM Sales.SalesOrderHeader AS S1
WHERE TotalDue >= 5000;

SELECT OrderDate, TotalDue,
(SELECT MIN(OrderDate)
FROM Sales.SalesOrderHeader AS S2
WHERE S2.OrderDate > S1.OrderDate
AND TotalDue < 5000) AS G
FROM Sales.SalesOrderHeader AS S1
WHERE TotalDue >= 5000;

SELECT MIN(OrderDate) AS DataOd, MAX(OrderDate) AS DataDo,
DATEDIFF(day, MIN(OrderDate), MAX(OrderDate)) + 1 AS Dni, MAX(TotalDue) 
FROM 
  (SELECT OrderDate, TotalDue,
         (SELECT MIN(OrderDate)
         FROM Sales.SalesOrderHeader AS S2
         WHERE S2.OrderDate > S1.OrderDate
         AND TotalDue < 5000) AS G
  FROM Sales.SalesOrderHeader AS S1
  WHERE TotalDue >= 5000) AS D
GROUP BY G;

SELECT CustomerID 
FROM Sales.Customer SC
WHERE EXISTS 
(SELECT * 
FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID);

SELECT CustomerID 
FROM Sales.Customer SC
WHERE CustomerID IN 
(SELECT  CustomerID
FROM Sales.SalesOrderHeader OH
WHERE SC.CustomerID = OH.CustomerID);

SELECT S.SalesPersonID
FROM Sales.SalesPerson AS S
WHERE EXISTS
  (SELECT *
  FROM Sales.SalesTerritoryHistory AS H
  WHERE S.SalesPersonID=H.SalesPersonID
  AND S.TerritoryID<>H.TerritoryID);

SELECT AddressID,City,AddressLine1
FROM Person.Address AS Z
WHERE EXISTS
  (SELECT *
  FROM Person.Address AS W
  WHERE Z.City=W.City
  AND Z.AddressLine1=W.AddressLine1
  AND Z.AddressID<>W.AddressID);

SELECT S.SalesPersonID
FROM Sales.SalesPerson AS S
WHERE NOT EXISTS
  (SELECT *
  FROM Sales.SalesTerritoryHistory AS H
  WHERE S.SalesPersonID=H.SalesPersonID
  AND S.TerritoryID<>H.TerritoryID);

SELECT ProductID
FROM Production.Product AS Z
WHERE NOT EXISTS 
(SELECT ProductID
FROM Production.Product AS W
WHERE W.ProductID = Z.ProductID+1);

SELECT ProductID+1
FROM Production.Product AS Z
WHERE NOT EXISTS 
  (SELECT ProductID
  FROM Production.Product AS W1
  WHERE W1.ProductID = Z.ProductID+1)
  AND ProductID < 
         (SELECT MAX(ProductID)
         FROM Production.Product AS W2);

SELECT EmployeeID
FROM HumanResources.Employee
WHERE HireDate IN
  (SELECT OrderDate
  FROM Sales.SalesOrderHeader);

SELECT EmployeeID
FROM HumanResources.Employee
WHERE HireDate = ANY
  (SELECT OrderDate
  FROM Sales.SalesOrderHeader);

SELECT Name
FROM Production.Product
WHERE Name < ANY
  (SELECT Name
  FROM Production.ProductCategory)
ORDER BY Name DESC;

SELECT TOP 1 Name
FROM Production.ProductCategory 
ORDER BY Name DESC;

SELECT Name
FROM Production.Product AS Z
WHERE EXISTS
  (SELECT *
  FROM Production.ProductCategory AS W
  WHERE Z.Name <W.Name)
ORDER BY Name DESC;

SELECT SalesOrderID, TotalDue
FROM Sales.SalesOrderHeader
WHERE OrderDate = '2002-12-31'
ORDER BY TotalDue DESC;

SELECT DISTINCT TotalDue
FROM Sales.SalesOrderHeader
WHERE TotalDue > ANY
  (SELECT TotalDue
  FROM Sales.SalesOrderHeader
  WHERE OrderDate = '2002-12-31')
ORDER BY TotalDue ASC;

SELECT SalesOrderID, TotalDue
FROM Sales.SalesOrderHeader
WHERE TotalDue < ANY
  (SELECT TotalDue
  FROM Sales.SalesOrderHeader OH
  JOIN Sales.SalesTerritory T
  ON T.TerritoryID = OH.TerritoryID
  WHERE T.Name = 'Australia');

SELECT TotalDue
FROM Sales.SalesOrderHeader
WHERE TotalDue > ANY
  (SELECT TotalDue
  FROM Sales.SalesOrderHeader
  WHERE OrderDate = '2012-12-31');

SELECT Name
FROM Production.Product
WHERE ListPrice > ALL
  (SELECT ListPrice
  FROM Production.Product
  WHERE ProductSubcategoryID =1);

SELECT MAX(ListPrice)
FROM Production.Product
WHERE ProductSubcategoryID =1
GROUP BY ();

SELECT Z.Name, Z.ListPrice
FROM Production.Product AS Z
WHERE NOT EXISTS 
  (SELECT *
  FROM Production.Product AS W
  WHERE ProductSubcategoryID =1
  AND Z.ListPrice<=W.ListPrice);

SELECT Name
FROM Production.Product
WHERE ListPrice <> ALL
  (SELECT ListPrice
  FROM Production.Product
  WHERE ProductSubcategoryID =2);

SELECT TotalDue
FROM Sales.SalesOrderHeader
WHERE TotalDue > All
  (SELECT TotalDue
  FROM Sales.SalesOrderHeader
  WHERE OrderDate = '2012-12-31');
