USE master;
CREATE DATABASE Test;
GO

EXEC sp_helpdb 'Test';
GO

CREATE DATABASE [TestMS]
 CONTAINMENT = NONE
 ON  PRIMARY 
( NAME = N'TestMS', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL12.MSSQLSERVER\MSSQL\DATA\TestMS.mdf' , SIZE = 5120KB , FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'TestMS_log', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL12.MSSQLSERVER\MSSQL\DATA\TestMS_log.ldf' , SIZE = 1024KB , FILEGROWTH = 10%)
GO
ALTER DATABASE [TestMS] SET COMPATIBILITY_LEVEL = 120
GO
ALTER DATABASE [TestMS] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [TestMS] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [TestMS] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [TestMS] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [TestMS] SET ARITHABORT OFF 
GO
ALTER DATABASE [TestMS] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [TestMS] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [TestMS] SET AUTO_CREATE_STATISTICS ON
GO
ALTER DATABASE [TestMS] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [TestMS] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [TestMS] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [TestMS] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [TestMS] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [TestMS] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [TestMS] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [TestMS] SET  DISABLE_BROKER 
GO
ALTER DATABASE [TestMS] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [TestMS] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [TestMS] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [TestMS] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [TestMS] SET  READ_WRITE 
GO
ALTER DATABASE [TestMS] SET RECOVERY FULL 
GO
ALTER DATABASE [TestMS] SET  MULTI_USER 
GO
ALTER DATABASE [TestMS] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [TestMS] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO
ALTER DATABASE [TestMS] SET DELAYED_DURABILITY = DISABLED 
GO
USE [TestMS]
GO
IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'PRIMARY') ALTER DATABASE [TestMS] MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

DROP DATABASE TestMS;
GO

USE master;
ALTER DATABASE TestMS
SET SINGLE_USER 
WITH ROLLBACK IMMEDIATE;

DROP DATABASE TestMS;
GO

USE Test;
CREATE TABLE T1 (
ID INT,
Nazwa VARCHAR(50),
Cena MONEY,
DataZakupu DATE);
GO

DROP TABLE T1; 
GO

CREATE SCHEMA Produkcja;
GO

CREATE TABLE Produkcja.Towary (
ID INT IDENTITY,
Nazwa VARCHAR(50),
Cena MONEY,
DataZakupu DATE);
GO

ALTER TABLE Produkcja.Towary 
ADD Kolor VARCHAR(10);
GO

ALTER TABLE Produkcja.Towary 
DROP COLUMN Kolor
GO

ALTER TABLE Produkcja.Towary 
ADD Rabat MONEY NOT NULL;
GO

ALTER TABLE Produkcja.Towary 
ALTER COLUMN Nazwa VARCHAR(50) NOT NULL;
GO

ALTER TABLE Produkcja.Towary 
ALTER COLUMN DataZakupu DATE NULL;
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT PK_Towary PRIMARY KEY (ID);
GO

CREATE TABLE Produkcja.Czci (
	ID INT PRIMARY KEY,
	Nazwa VARCHAR(30) NOT NULL);
GO

ALTER TABLE Produkcja.Towary 
DROP CONSTRAINT PK_Towary;

ALTER TABLE Produkcja.Towary 
DROP COLUMN ID;

ALTER TABLE Produkcja.Towary 
ADD ID INT IDENTITY (1,1) CONSTRAINT PK_Towary PRIMARY KEY;
GO

DROP TABLE Produkcja.Czci;
GO
CREATE TABLE Produkcja.Czci (
ID INT IDENTITY (100,1) CONSTRAINT PK_Czesci PRIMARY KEY,
Nazwa VARCHAR(30) NOT NULL);
GO

CREATE TABLE dbo.T1 (C1 INT NOT NULL);
CREATE TABLE dbo.T2 (C2 INT NOT NULL);
GO

CREATE SEQUENCE dbo.S1 AS INT 
START WITH 1 INCREMENT BY 1;
GO

INSERT INTO dbo.T1 (C1) 
VALUES (NEXT VALUE FOR dbo.S1);
INSERT INTO dbo.T2 (C2) 
VALUES (NEXT VALUE FOR dbo.S1);
GO

SELECT * FROM dbo.T1;
SELECT * FROM dbo.T2;
GO

CREATE TABLE dbo.Znajomi(
Nazwisko VARCHAR(50),
Imi VARCHAR(20),
DataUr DATE,
CONSTRAINT PK_Znajomi PRIMARY KEY (Nazwisko,Imi));
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT U_NazwaTowaru UNIQUE (Nazwa);  

ALTER TABLE Produkcja.Czci
ADD Kod CHAR(5) NOT NULL CONSTRAINT U_CzesciKod UNIQUE
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT DF_TowaryData DEFAULT GETDATE() FOR DataZakupu;

ALTER TABLE Produkcja.Czci
ADD Jakosc SMALLINT CONSTRAINT DF_CzesciJakosc DEFAULT 5
GO

ALTER TABLE Produkcja.Czci
ADD CONSTRAINT CK_CzesciJakosc CHECK (Jakosc BETWEEN 0 AND 5);

ALTER TABLE Produkcja.Towary 
ADD DataSprzedazy DATE;
GO

ALTER TABLE Produkcja.Towary 
ADD CONSTRAINT CK_TowaryData CHECK (DataSprzedazy  BETWEEN DataZakupu AND GETDATE());
GO

ALTER TABLE Produkcja.Czci
ADD IDTowaru INT REFERENCES Produkcja.Towary;
GO

ALTER TABLE Produkcja.Czci
DROP CONSTRAINT FK__Czci__IDTowaru__108B795B; --ZA KAZDYM RAZEM ID BEDZIE INNE
GO

ALTER TABLE Produkcja.Czci
DROP COLUMN IDTowaru;
GO

ALTER TABLE Produkcja.Czci
DROP CONSTRAINT FK__Czci__IDTowaru__20C1E124

ALTER TABLE Produkcja.Czci
DROP COLUMN IDTowaru;
GO

ALTER TABLE Produkcja.Czci
ADD IDTowaru INT CONSTRAINT FK_Towary REFERENCES Produkcja.Towary (ID);
GO

ALTER TABLE Produkcja.Czci
ADD IDCzesci INT CONSTRAINT FK_Czesci REFERENCES Produkcja.Czci;
GO

ALTER TABLE Produkcja.Czci
DROP CONSTRAINT FK_Towary;
GO

ALTER TABLE Produkcja.Czci
ADD CONSTRAINT FK_Towary  FOREIGN KEY (IDCzesci)
REFERENCES Produkcja.Towary
ON UPDATE CASCADE
ON DELETE SET NULL
GO

USE AdventureWorksLT2012
GO

SELECT * 
FROM [SalesLT].[SalesOrderDetail]
WHERE [OrderQty] <0;
GO

ALTER TABLE [SalesLT].[SalesOrderDetail]
ADD CONSTRAINT CK_OrderQty CHECK (OrderQty >= 0);
GO


