#include <windows.h>
#include <commctrl.h>
#include "resource.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
HWND hToolbar;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  //Inicjalizuj obsug wsplnych obiektw sterujcych
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Toolbar", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      TBBUTTON przyciski[6];
      /* Zeruj zawarto pl 
         wszystkich elementw tablicy */
      memset(przyciski, 0, sizeof(TBBUTTON)*6);
      
      // Przygotuj informacje o przyciskach
      przyciski[0].iBitmap = 0;
      przyciski[0].idCommand = ID_NOWY;
      przyciski[0].fsState = TBSTATE_ENABLED;
      przyciski[0].fsStyle = TBSTYLE_BUTTON;
      
      przyciski[1].iBitmap = 1;
      przyciski[1].idCommand = ID_OTWORZ;
      przyciski[1].fsState = TBSTATE_ENABLED;
      przyciski[1].fsStyle = TBSTYLE_BUTTON;
      
      przyciski[2].fsStyle = TBSTYLE_SEP;

      przyciski[3].iBitmap = 2;
      przyciski[3].idCommand = ID_WYTNIJ;
      przyciski[3].fsState = TBSTATE_ENABLED;
      przyciski[3].fsStyle = TBSTYLE_BUTTON;
      
      przyciski[4].iBitmap = 3;
      przyciski[4].idCommand = ID_KOPIUJ;
      przyciski[4].fsState = TBSTATE_ENABLED;
      przyciski[4].fsStyle = TBSTYLE_BUTTON;

      przyciski[5].iBitmap = 4;
      przyciski[5].idCommand = ID_WKLEJ;
      przyciski[5].fsState = TBSTATE_ENABLED;
      przyciski[5].fsStyle = TBSTYLE_BUTTON;

      // Twrz pasek narzdziowy      
      hToolbar = CreateToolbarEx(okno, 
        WS_CHILD | WS_BORDER | WS_VISIBLE,
        200, 5, zadanie, ID_BITMAP, przyciski,
        6, 0, 0, 16, 16, sizeof(TBBUTTON));
      return 0;
    }
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case ID_NOWY:
          MessageBox(okno,"Nowy","",MB_OK);
          break;
        case ID_OTWORZ:
          MessageBox(okno,"Otworz","",MB_OK);
          break;
        case ID_WYTNIJ:
          MessageBox(okno,"Wytnij","",MB_OK);
          break;
        case ID_KOPIUJ:
          MessageBox(okno,"Kopiuj","",MB_OK);
          break;
        case ID_WKLEJ:
          MessageBox(okno,"Wklej","",MB_OK);
          break;
      }
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
