#include <windows.h>
#include <stdio.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
int ObslugaSuwaka(WPARAM, int, int, int, int);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
HWND hScrollbar;
/* Zmienne przechowujce pooenie suwakw 
   w paskach przewijania */
int pozX = 0, pozY = 0, pozS = 0;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  
  zadanie = zad;
  /* Twrz okno zawierajce poziomy 
     oraz pionowy pasek przewijania */
  HWND okno = CreateWindowEx(0,nazwaKlasy, "Mj program", 
                WS_OVERLAPPEDWINDOW | 
                WS_VSCROLL | WS_HSCROLL,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  char bufor[100];
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Twrz dodatkowy pasek przewijania
      hScrollbar = CreateWindow("SCROLLBAR", NULL,
        WS_CHILD | WS_VISIBLE ,
        0, 0, 0, 0, okno, NULL, zadanie, NULL);
      // oraz ustaw jego zakres na 0-50
      SetScrollRange(hScrollbar, SB_CTL, 0, 50, FALSE);
      return 0;
    }
    case WM_SIZE:
      /* Umie dodatkowy pasek przewijania 
         w grnej czci obszaru klienta okna */
      MoveWindow(hScrollbar, 0, 0, LOWORD(lParam), 
                 20, TRUE);
      return 0;
    case WM_PAINT:
    {
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      /* Wywietl informacje o pooeniu suwakw
         poszczeglnych paskw przewijania */
      sprintf(bufor, "Dodatkowy pasek u gry okna:%d  ", pozS);
      TextOut(kont, 20, 30, bufor, strlen(bufor));
      sprintf(bufor, "Pionowy pasek przewijania:%d  ", pozY);
      TextOut(kont, 20, 50, bufor, strlen(bufor));
      sprintf(bufor, "Poziomy pasek przewijania:%d  ", pozX);
      TextOut(kont, 20, 70, bufor, strlen(bufor));
      EndPaint(okno, &ps);
      return 0;
    }
    case WM_VSCROLL:
      // Okrel now pozycj suwaka
      pozY = ObslugaSuwaka(wParam, pozY, 0, 100, 20);
      // Ustaw suwak w nowej pozycji
      SetScrollPos(okno, SB_VERT, pozY, TRUE);
      /* Odmaluj zawarto okna w celu 
         wywietlenia nowej pozycji suwaka */
      InvalidateRect(okno, NULL, FALSE);
      return 0;
    case WM_HSCROLL:
      if(lParam == 0)
      {
        // Okrel now pozycj suwaka	
        pozX = ObslugaSuwaka(wParam, pozX, 0, 100, 20);
        // Ustaw suwak w nowej pozycji
        SetScrollPos(okno, SB_HORZ, pozX, TRUE);
      }
      else
      {
        // Okrel now pozycj suwaka
        pozS = ObslugaSuwaka(wParam, pozS, 0, 50, 10);
        // Ustaw suwak w nowej pozycji
        SetScrollPos(hScrollbar, SB_CTL, pozS, TRUE);
      }
      /* Odmaluj zawarto okna w celu 
         wywietlenia nowej pozycji suwaka */
      InvalidateRect(okno, NULL, FALSE);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

/* Funkcja ObslugaSuwaka zwraca now pozycj suwaka, 
   obliczon na podstawie jego poprzedniego pooenia,
   wartoci parametru wParam, rozmiaru strony,
   oraz podanego zakresu min-max */
   
int ObslugaSuwaka(WPARAM wParam, int poz, 
                  int min, int max, int strona)
{ 
  switch(LOWORD(wParam))
  {
    case SB_BOTTOM:         poz = min; break;
    case SB_TOP:            poz = max; break;
    case SB_LINEDOWN:       poz ++; break;
    case SB_LINEUP:         poz --; break; 
    case SB_PAGEDOWN:       poz += strona; break;
    case SB_PAGEUP:         poz -= strona; break;
    case SB_THUMBPOSITION:  poz = HIWORD(wParam); break;
    case SB_THUMBTRACK:     poz = HIWORD(wParam); break;
  }
  /* Sprawd, czy pozycja suwaka nie przekroczya 
     przedziau od min do max */
  if (poz < min) poz = min;
  if (poz > max) poz = max;

  return poz;
}
