#include <windows.h>
#include "menu.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

// Nazwa klasy rejestrowanej w systemie dla naszego okna
char nazwaKlasy[] = "nazwa1";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
    LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  /* Wypenij struktur suc do zarejestrowania 
     klasy okna w systemie */
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "menu1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  // Rejestruj okno w systemie
  if(!RegisterClass(&klasaOkna)) return 0;

  /* Stwrz okno o standardowym stylu oraz 
     domylnym pooeniu i rozmiarach */
  HWND okno = CreateWindowEx(0,nazwaKlasy, 
		"Demonstracja menu", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  // Wywietl okno
  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDM_OTWORZ:
          MessageBox(okno, "Otwrz", "", MB_OK);
          break;
        case IDM_ZAMKNIJ:
          MessageBox(okno, "Zamknij", "", MB_OK);
          break;
        case IDM_KONIEC:
          DestroyWindow(okno); /* Zniszcz okno */
          break;
        case IDM_OPCJA1:
          MessageBox(okno, "Opcja 1", "", MB_OK);
          break;
        case IDM_OPCJA2:
          MessageBox(okno, "Opcja 2", "", MB_OK);
          break;
        case IDM_OPCJA3:
          MessageBox(okno, "Opcja 3", "", MB_OK);
          break;
        case IDM_HELP:
          MessageBox(okno, 
           "Program demonstrujcy uycie menu", "", MB_OK);
          break;
      }
      break;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      break;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
  return 0;
}
