#include <windows.h>
#include "akcel.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

// Nazwa klasy rejestrowanej w systemie dla naszego okna
char nazwaKlasy[] = "nazwa1";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, LPSTR, 
                   int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "menu1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  // Rejestruj okno w systemie
  if(!RegisterClass(&klasaOkna)) return 0;

  /* Stwrz okno o standardowym stylu oraz domylnym 
     pooeniu i rozmiarach */
  HWND okno = CreateWindowEx(0,nazwaKlasy, 
                "Demonstracja uycia akceleratorw", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  // Wywietl okno
  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  HACCEL hAkceleratory = LoadAccelerators(zad, "akcel1");

  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    if(!TranslateAccelerator(okno, hAkceleratory, &komunikat))
    {
      TranslateMessage(&komunikat);
      DispatchMessage(&komunikat);
    }
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDM_NOWY:
          MessageBox(okno, "Nowy", "", MB_OK);
          break;
        case IDM_OTWORZ:
          MessageBox(okno, "Otwrz", "", MB_OK);
          break;
        case IDM_ZAPISZ:
          MessageBox(okno, "Zapisz", "", MB_OK);
          break;
        case IDM_ZAMKNIJ:
          MessageBox(okno, "Zamknij", "", MB_OK);
          break;
        case IDM_KONIEC:
          DestroyWindow(okno); /* Zniszcz okno */
          break;
        case IDM_HELP:
          MessageBox(okno, 
              "Program demonstrujcy uycie akceleratorw",
              "", MB_OK);
          break;
      }
      break;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      break;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
  return 0;
}
