#include <windows.h>
#include <string.h>
#include <stdlib.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

int CALLBACK CzytajFonty(ENUMLOGFONT FAR* lpelf,	
  NEWTEXTMETRIC FAR* lpntm, int FontType, LPARAM lParam );

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Okna typu Combobox i Edit
HWND hComboBox, hComboBox2, hEdit;
// Przyciski stylw
HWND hPogrubienie, hKursywa, hPodkreslenie;
// Bufor przechowujcy nazw wybranego kroju
char font[LF_FACESIZE];
// Wielko czcionki
int wielkosc=10;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = CS_VREDRAW | CS_HREDRAW;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;
  HWND okno = CreateWindowEx(0,nazwaKlasy, "Fonty", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Moliwe do wybrania wielkoci czcionki
      char *rozmiary[16] = 
         {"8","9","10","11","12","14","16","18",
          "20","22","24","26","28","36","48","72" };
      
      HDC kont = GetDC(okno);
      
      // Twrz dwa okna typu Combobox
      hComboBox = CreateWindowEx(0, "COMBOBOX", NULL, 
        WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST
        | CBS_SORT | WS_VSCROLL,
        0, 0, 250, 200, okno, NULL, zadanie, NULL);
      hComboBox2 = CreateWindowEx(0, "COMBOBOX", NULL, 
        WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST 
        | WS_VSCROLL,
        250, 0, 50, 200, okno, NULL, zadanie, NULL);
      
      // Twrz przyciski styli
      hPogrubienie = CreateWindowEx(0, "BUTTON", "B",
        WS_CHILD | WS_VISIBLE 
        | BS_AUTOCHECKBOX | BS_PUSHLIKE,
        300,0,26,26, okno, NULL, zadanie, NULL);
      hKursywa = CreateWindowEx(0, "BUTTON", "/",
        WS_CHILD | WS_VISIBLE 
        | BS_AUTOCHECKBOX | BS_PUSHLIKE,
        326,0,26,26, okno, NULL, zadanie, NULL);
      hPodkreslenie = CreateWindowEx(0, "BUTTON", "&U",
        WS_CHILD | WS_VISIBLE 
        | BS_AUTOCHECKBOX | BS_PUSHLIKE,
        352,0,26,26, okno, NULL, zadanie, NULL);
      
      // Twrz okno typu Edit
      hEdit = CreateWindowEx(0, "EDIT", "0",
        WS_CHILD | WS_VISIBLE | WS_BORDER | ES_NUMBER, 
        420, 0, 40, 26, okno, NULL, zadanie, NULL);
      
        /* Wywoaj funkcj CzytajFonty dla wszystkich 
           fontw zainstalowanych w systemie */
      EnumFontFamilies(kont, NULL, 
        (FONTENUMPROC)CzytajFonty, NULL);
      /* Wybierz wstpnie pierwsz pozycj z listy
         dostpnych fontw */
      SendMessage(hComboBox,CB_SETCURSEL,0,0);
      /* Odczytaj nazw wybranego fontu do 
         zmiennej globalnej font */
      SendMessage(hComboBox,CB_GETLBTEXT,0,(LPARAM)font);
      // Obetnij pierwsze trzy znaki czyli "   " lub "TT "
      strcpy(font,font+3);

      /* Umie w drugim oknie Combobox typowe
         wielkoci czcionek */
      for(int i=0; i<16; i++)
        SendMessage(hComboBox2 ,CB_ADDSTRING, 
                    0, (LPARAM)rozmiary[i]);
      /* Wybierz wstpnie trzeci warto z listy
         czyli wielko 10 */
      SendMessage(hComboBox2, CB_SETCURSEL,2,0);

      ReleaseDC(okno, kont);
      return 0;
    }
    case WM_PAINT:
    {
      LOGFONT lf;
      PAINTSTRUCT paint;
      char buf[5];
      HDC kont = BeginPaint(okno,&paint);
      TextOut(kont,380,4,"Kt:",4);
      
      // Wypenij wszystkie pola struktury lf zerami
      memset(&lf,0,sizeof(lf));
      
      // Wpisz wartoci do odpowiednich pl
      lf.lfHeight = wielkosc*2;
      lf.lfWeight = FW_NORMAL;
      lf.lfCharSet = DEFAULT_CHARSET;
      // Sprawd stan przycisku pogrubienia
      if(SendMessage(hPogrubienie, BM_GETCHECK, 0, 0) 
           == BST_CHECKED)
        lf.lfWeight = FW_BOLD;
      /* Przepisz stan przyciskw kursywy i podkrelenia 
         do odpowiednich pl */
      lf.lfItalic = (BYTE)SendMessage(hKursywa, 
                                      BM_GETCHECK, 0, 0);
      lf.lfUnderline = (BYTE)SendMessage(hPodkreslenie, 
                                      BM_GETCHECK, 0, 0);
      // Skopiuj nazw fontu do odpowiedniego pola
      strcpy(lf.lfFaceName,font); 

      // Odczytaj zawarto pola Edit
      SendMessage(hEdit,WM_GETTEXT,4,(LPARAM)buf);
      // i okrel na tej podstawie kt wywietlania tekstu
      lf.lfEscapement = lf.lfOrientation = atoi(buf)*10;
      
      // Twrz czcionk i wywietl nazw kroju
      HFONT hFont = CreateFontIndirect(&lf);
      hFont = SelectObject(kont, hFont);
      TextOut(kont,100,300,font,strlen(font));
      hFont = SelectObject(kont, hFont);
      DeleteObject(hFont);
      EndPaint(okno,&paint);
      return 0;
    }
    case WM_COMMAND:
      switch(HIWORD(wParam))
      { // Wybrano z listy wartoci w oknie typu Combobox
        case CBN_SELCHANGE:

          // Combobox zawierajcy nazwy fontw
          if((HWND)lParam == hComboBox)
          { 
            // Odczytaj element wybrany z listy
            SendMessage(hComboBox, WM_GETTEXT, 
                        LF_FACESIZE,(LPARAM)font);
            /* Obetnij pierwsze trzy znaki,
               czyli "   " lub "TT " */
            strcpy(font,font+3);
          }
          
          // Combobox zawierajcy wielkoci fontw
          else if((HWND)lParam == hComboBox2)
          { 
            char rozmiar[5];
            // Odczytaj element wybrany z listy
            SendMessage(hComboBox2, WM_GETTEXT,
                        5, (LPARAM)rozmiar);
            // Konwertuj tekst na liczb
            wielkosc = atoi(rozmiar);
          }

          /* Odmaluj okno, jeeli kliknito 
             na przycisku stylu */
        case BN_CLICKED:
          // lub zmieniono zawarto okna Edit
        case EN_CHANGE:
          InvalidateRect(okno,NULL,TRUE);
      }
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

/* Funkcja wywoywana przez EnumFontFamilies kolejno
   dla wszystkich fontw zainstalowanych w systemie */
int CALLBACK CzytajFonty(ENUMLOGFONT FAR*  lpelf,	
  				   NEWTEXTMETRIC FAR* lpntm,	
   int FontType, LPARAM lParam )
{
  /* Lokalny bufor na nazw fontu oraz poprzedzajce 
     j trzy znaki, pocztkowo spacje */
  char f[LF_FACESIZE+3]="   ";
  /* Skopiuj nazw fontu do bufora pozostawiajc w nim
     trzy pierwsze spacje */
  strcpy(f+3,lpelf->elfLogFont.lfFaceName);
  /* Dla fontw TrueType zmie dwa pierwsze 
     znaki bufora na TT */
  if(FontType & TRUETYPE_FONTTYPE)
  {
    f[0]='T';
    f[1]='T';
  }
  // Dopisz nazw fontu do okna ComboBox
  SendMessage(hComboBox ,CB_ADDSTRING,0,(LPARAM)f);
  return 1;
}
