#include <windows.h>

#define SZEROKOSC 500
#define WYSOKOSC  350

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HBITMAP mapa; // uchwyt mapy bitowej
HDC kontMapy; // kontekst mapy bitowej
BOOL Elipsa;  // flaga rysowania elipsy
int xp,yp,xk,yk; /* wsprzdne prostokta 
    opisujcego elips */

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
    LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  if(!RegisterClass(&klasaOkna)) return 0;

  /* Stwrz okno bez ramki umoliwiajcej zmian 
     jego rozmiaru oraz bez przycisku maksymalizacji */
  HWND okno = CreateWindowEx(0,nazwaKlasy, "Grafika", 
                WS_OVERLAPPED | WS_CAPTION 
                | WS_SYSMENU | WS_MINIMIZEBOX,
                50, 50, SZEROKOSC, WYSOKOSC,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Pobierz kontekst ekranu
      HDC kont = GetDC(okno);
      // Stwrz map bitow zgodn z kontekstem ekranu
      mapa = CreateCompatibleBitmap(kont, SZEROKOSC, WYSOKOSC);
      // Stwrz kontekst dla mapy bitowej
      kontMapy = CreateCompatibleDC(kont);
      // Wybierz map do utworzonego kontekstu
      SelectObject(kontMapy, mapa);
      // Wypenij map bitow biaym pdzlem
      PatBlt(kontMapy, 0, 0, SZEROKOSC, WYSOKOSC, WHITENESS);
      // Zwolnij kontekst ekranu
      ReleaseDC(okno, kont);
      // Ustaw flag rysowania elipsy na FALSE
      Elipsa = FALSE;
      return 0;
    }
    case WM_LBUTTONDOWN:
    {
      /* Zapamitaj wsprzdne kursora myszki 
        przy naciniciu jej lewego przycisku */
      xp = xk = LOWORD(lParam);
      yp = yk = HIWORD(lParam);
      // Ustaw flag rysowania elipsy na TRUE
      Elipsa = TRUE;
      return 0;
    }          
    case WM_MOUSEMOVE:
    { /* Przy przesuwaniu myszki i przycinitym 
         jej lewym klawiszu rysuj na ekranie 
         cienk lini makiet elipsy */
      if(Elipsa && LOWORD(lParam)>xp && HIWORD(lParam)>yp)
      {
        HDC kont = GetDC(okno);
        /* odtwrz z mapy bitowej zawarto ekranu 
           pod makiet elipsy narysowan podczas obsugi 
           poprzedniego komunikatu WM_MOUSEMOVE */
        BitBlt(kont, xp, yp, xk-xp, yk-yp, 
               kontMapy, xp, yp, SRCCOPY);
        /* Pobierz nowe wsprzdne prawego dolnego
           rogu prostokta opisujcego elips */
        xk = LOWORD(lParam);
        yk = HIWORD(lParam);
        // Uyj przeroczystego pdzla
        HBRUSH pedzel = GetStockObject(NULL_BRUSH);
        pedzel = SelectObject(kont, pedzel);
        // Rysuj makiet elipsy bezporednio na ekranie
        Ellipse(kont,xp,yp,xk,yk); 
        SelectObject(kont, pedzel);
        ReleaseDC(okno,kont);
      }
      return 0;
    }
    case WM_LBUTTONUP:
    { /* Przy puszczeniu lewego klawisza myszki rysuj
         waciw elips na mapie bitowej */
      HPEN pioro = CreatePen(PS_SOLID,4,RGB(0,160,0));
      HBRUSH pedzel = CreateSolidBrush(RGB(220,0,180));
      pioro = SelectObject(kontMapy,pioro);
      pedzel = SelectObject(kontMapy,pedzel);
      Ellipse(kontMapy,xp,yp,xk,yk); 
      pioro = SelectObject(kontMapy,pioro);
      pedzel = SelectObject(kontMapy,pedzel);
      DeleteObject(pioro);
      DeleteObject(pedzel);
      /* Uniewanij zawarto obszaru klienta okna,
         aby mapa bitowa zostaa wywietlona w oknie
         podczas obsugi komunikatu WM_PAINT */
      InvalidateRect(okno, NULL, FALSE);
      Elipsa = FALSE;
      return 0;
    }
    case WM_PAINT:
    {
      PAINTSTRUCT paint;
      HDC kont = BeginPaint(okno, &paint);
      // Wywietl map bitow
      BitBlt(kont, 0, 0, SZEROKOSC, WYSOKOSC,
             kontMapy, 0, 0, SRCCOPY);
      EndPaint(okno, &paint);
      return 0;
    } 
    case WM_DESTROY:
      DeleteDC(kontMapy); // usu kontekst mapy bitowej
      DeleteObject(mapa); // usu map bitow
      PostQuitMessage(0); // zakocz program 
      break;
    default:
      return DefWindowProc(okno, komunikat, wParam, lParam);
  }
  return 0;
}
