#include <windows.h>
#include "Pasek.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

/* Uchwyt menu wywietlanego po klikniciu 
   na ikonie programu umieszczonej w obszarze 
   informacyjnym paska zada */
HMENU hMenu;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = NULL;
  klasaOkna.hCursor = NULL;
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  hMenu = GetSubMenu(LoadMenu(zadanie,"menu1"),0);

  // Stwrz okno ale nie wywietlaj go
  HWND okno = CreateWindowEx(0, nazwaKlasy, "", 
                WS_OVERLAPPEDWINDOW, 0, 0, 0, 0,
                NULL, NULL, zad, NULL);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      /* Umie ikon w obszarze informacyjnym paska zada */
      NOTIFYICONDATA nid;
      nid.cbSize = sizeof(NOTIFYICONDATA);
      nid.hWnd = okno;
      nid.uID = 100;
      nid.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
      nid.uCallbackMessage = WM_USER;
      nid.hIcon = LoadIcon(zadanie, "ikona1");
      lstrcpy(nid.szTip, "Mj program");
      Shell_NotifyIcon(NIM_ADD, &nid);
      return 0;
    }
    case WM_USER:
      // Uytkownik klikn na ikonie
      if((UINT)lParam == WM_LBUTTONDOWN ||
         (UINT)lParam == WM_RBUTTONDOWN )
      {
        // Odczytaj wsprzdne kursora myszki
        POINT punkt;
        GetCursorPos(&punkt);
        // Wywietl menu
        TrackPopupMenu(hMenu, TPM_RIGHTALIGN, 
          punkt.x, punkt.y, 0, okno, NULL);
      }
      return 0;
    case WM_COMMAND:
      // Uytkownik wybra polecenie z menu
      switch(LOWORD(wParam))
      {
        case IDM_INFO:
          // Wywietl informacje o programie
          MessageBox(okno, 
            "Program demonstruje sposb wykorzystania\n\
     	    obszaru informacyjnego paska zada",
            "Informacja", MB_OK);
          return 0;
        case IDM_ZAMKNIJ:
          // Zakocz program
          DestroyWindow(okno);
          return 0;
      }
      return 0;
    case WM_DESTROY:
    {
      // Usu ikon z paska zada
      NOTIFYICONDATA nid;
      nid.cbSize = sizeof(NOTIFYICONDATA);
      nid.hWnd = okno;
      nid.uID = 100;
      Shell_NotifyIcon(NIM_DELETE, &nid);

      PostQuitMessage(0); /* zakocz program */
      return 0;
    }
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
