#define ID_PREDKOSC 110

#include <windows.h>
#include <commctrl.h>
#include <scrnsave.h>

void Odczytaj();
void Zapisz();

// Prdko wywietlania belek w 1/10 sekundy
LONG predkosc = 10;
// Uchwyt palety logicznej
HPALETTE hpal;
// Pocztkowy kolor pierwszej belki
int kolor=0;
// Pierwsza belka pionowa
BOOL pionowy = TRUE;
 
// Procedura dialogu konfiguracyjnego
BOOL WINAPI ScreenSaverConfigureDialog(HWND dialog, 
            UINT komunikat, WPARAM wParam, LPARAM lParam) 
{ 
  switch(komunikat) 
  { 
    case WM_INITDIALOG: 

      // Odczytaj prdko z rejestru
      Odczytaj();
    
      // Ustaw zakres paska przesuwnego na 0-20
      SendDlgItemMessage(dialog, ID_PREDKOSC, 
        TBM_SETRANGE, TRUE, MAKELONG(0,20));
      // Ustaw pozycj suwaka zalenie od prdkoci
      SendDlgItemMessage(dialog, ID_PREDKOSC, TBM_SETPOS, 
                         (WPARAM)TRUE, predkosc);
      return TRUE; 
    case WM_COMMAND: 
      switch(LOWORD(wParam)) 
      { 
        case IDOK:
          predkosc = SendDlgItemMessage(dialog, 
                        ID_PREDKOSC, TBM_GETPOS, 0, 0);
          // Zapisz prdko do rejestru
          Zapisz();
          EndDialog(dialog, TRUE);
        case IDCANCEL: 
          EndDialog(dialog, FALSE); 
          return TRUE; 
      } 
  } 
  return FALSE; 
} 

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{ 
  InitCommonControls();
  return TRUE; 
}

LONG WINAPI ScreenSaverProc(HWND okno, UINT komunikat, 
                            WPARAM wParam, LPARAM lParam) 
{ 
  static HDC kont;
  static RECT prost;
  static UINT uTimer;
  int i;
 
  switch(komunikat) 
  { 
    case WM_CREATE: 
    {
      // Twrz palet logiczn
      int rozm = sizeof(LOGPALETTE) + 95 * sizeof(PALETTEENTRY);
      LPLOGPALETTE lpal = (LPLOGPALETTE) new char[rozm];
      memset(lpal, 0, rozm);
      lpal->palVersion = 0x300;
      lpal->palNumEntries = 96;
      for(i=0; i<16; i++)
        lpal->palPalEntry[i].peRed = 
        lpal->palPalEntry[16+i].peGreen = 
        lpal->palPalEntry[32+i].peBlue = 
        lpal->palPalEntry[48+i].peRed = 
        lpal->palPalEntry[48+i].peGreen = 
        lpal->palPalEntry[64+i].peGreen = 
        lpal->palPalEntry[64+i].peBlue = 
        lpal->palPalEntry[80+i].peRed = 
        lpal->palPalEntry[80+i].peBlue = i*16;
      hpal = CreatePalette(lpal);
      // Ustaw now palet w kontekcie
      kont = GetDC(okno); 
      SelectPalette(kont, hpal, 0);
      RealizePalette(kont);
      ReleaseDC(okno,kont); 
      // Zwolnij przydzielon pami
      delete lpal;
      // Odczytaj prdko z rejestru
      Odczytaj();
      /* Wcz zegar generujcy komunikaty WM_TIMER
         co okres czasu = prdko*1/10 [sek] */
      uTimer = SetTimer(okno, 1, predkosc * 100, NULL); 
      break; 
    }
    case WM_TIMER: 
    {
      kont = GetDC(okno); 
      GetClientRect(okno, &prost);
      int x,y;
      /* Wyznacz pooenie belki w zalenoci 
         od jej orientacji */
      if(pionowy)
        x=rand() % (prost.right - 32);
      else
        y=rand() % (prost.bottom - 32);

      HPEN poppioro, pioro;
      for(i=0; i<32; i++)
      {
        // Twrz piro
        pioro = CreatePen(PS_SOLID, 1, 
          PALETTEINDEX(i<16 ? kolor + i : kolor + 31-i));
        // Wybierz piro w kontekcie
        poppioro = SelectObject(kont, pioro);
        // Rysuj pionow lub poziom lini
        if(pionowy)
        {
          MoveToEx(kont, x+i, 0, NULL);
          LineTo(kont, x+i, prost.bottom);
        }
        else
        {
          MoveToEx(kont, 0, y+i, NULL);
          LineTo(kont, prost.right, y+i);
        }
        // Przywr poprzednie piro do kontekstu
        SelectObject(kont, poppioro);
        DeleteObject(pioro);
      }
      ReleaseDC(okno,kont);
      // Nastpna belka w innym kolorze
      kolor = (kolor + 16) % 96;
      // Rysuj na przemian pionowe i poziome belki
      pionowy = !pionowy;
      break; 
    }
    case WM_DESTROY: 
      if (uTimer) 
        KillTimer(okno, uTimer); 
      DeleteObject(hpal);
      break; 
  } 
  return DefScreenSaverProc(okno, komunikat, 
                            wParam, lParam); 
} 

// Funkcja odczytuje prdko wygaszacza z rejestru
void Odczytaj()
{
  HKEY klucz;
  DWORD rozm = 4;
  // Otwrz odpowiedni klucz rejestru
  if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
      "SOFTWARE\\Belki", 0,
      KEY_QUERY_VALUE, &klucz) == ERROR_SUCCESS)
  {
    // Odczytaj prdko
    RegQueryValueEx(klucz, "Prdko", 0, NULL, 
                    (BYTE *)&predkosc, &rozm);          
    if(predkosc<0 || predkosc>20) predkosc = 10;
    // Zamknij otwarty klucz rejestru 
    RegCloseKey(klucz);
  }
}

// Funkcja zapisuje prdko wygaszacza do rejestru
void Zapisz()
{
  HKEY klucz;
  DWORD akcja;
  // Otwrz odpowiedni klucz rejestru
  RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
    "SOFTWARE\\Belki", 0, NULL,
    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
    &klucz, &akcja);
  // Zapisz informacje o prdkoci
  RegSetValueEx(klucz, "Prdko", 0, REG_DWORD,
                (CONST BYTE *)&predkosc, 4);
  // Zamknij otwarty klucz rejestru 
  RegCloseKey(klucz);
}
