#include <windows.h>
#include "mdi.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ProcDokumentu(HWND, UINT, WPARAM, LPARAM);

HINSTANCE zadanie;

// Uchwyt okna-klienta MDI
HWND klientMDI;
// Tytu okna dokumentu
char *tytulDokumentu = "Dokument 0";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{                         
  WNDCLASS klasaOkna;
  // Klasa gwnego okna aplikacji
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = "Okno aplikacji";
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  if(!RegisterClass(&klasaOkna)) return 0;

  // Klasa okna dokumentu
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = "Dokument";
  klasaOkna.lpfnWndProc = ProcDokumentu;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);

  if(!RegisterClass(&klasaOkna)) return 0;

  zadanie = zad;

  HWND okno = CreateWindowEx(WS_EX_CLIENTEDGE ,
                "Okno aplikacji", 
                "MDI", WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
    if(!TranslateMDISysAccel(klientMDI, &komunikat))
    {
      TranslateMessage(&komunikat);
      DispatchMessage(&komunikat);
    }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Twrz obszar klienta MDI
      CLIENTCREATESTRUCT ccs;
      ccs.hWindowMenu = GetSubMenu(GetMenu(okno), 1);
      ccs.idFirstChild = 200;
      klientMDI = CreateWindow("MDICLIENT", NULL, 
        WS_CHILD | WS_VSCROLL | WS_VISIBLE, 0, 0, 0, 0,
        okno, NULL, zadanie, (LPSTR)&ccs);
      return 0;
    }
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDM_NOWY:
        {
          /* Wpisz nastpny numer do tytuu okna 
             dokumentu (dziaa poprawnie tylko 
             dla pierwszych dziewiciu okien) */
          tytulDokumentu[9]++;
          /* Wypenij struktur MDICREATESTRUCT 
             i twrz nowe okno dokumentu */
          MDICREATESTRUCT mdic;
          mdic.szClass = "Dokument";
          mdic.szTitle = tytulDokumentu;
          mdic.hOwner = zadanie;
          mdic.x= mdic.y= mdic.cx= mdic.cy= CW_USEDEFAULT;
          mdic.style = 0;
          SendMessage(klientMDI, WM_MDICREATE, 
                      0, (LPARAM)&mdic);
          break;
        }
        case IDM_ZAMKNIJ:
        { 
          // Pobierz uchwyt aktywnego okna dokumentu
          HWND aktywne = (HWND)SendMessage(klientMDI, 
                         WM_MDIGETACTIVE, 0, 0);
          // i zamknij je o ile istnieje
          if(aktywne)
            SendMessage(klientMDI, WM_MDIDESTROY, 
                        (WPARAM)aktywne, 0);
          break;
        }
        case IDM_KAFELKI:
          // U okna dokumentw ssiadujco
          SendMessage( klientMDI, WM_MDITILE, 0, 0L );
          break;
        case IDM_KASKADA:
          // U okna dokumentw kaskadowo
          SendMessage( klientMDI, WM_MDICASCADE, 0, 0L );
          break;
        case IDM_UP_IKONY:
          // Uporzdkuj ikony zminimalizowanych okien
          SendMessage(klientMDI,WM_MDIICONARRANGE,0,0L );
          break;
        default:
          /* Koniecznie przeka nie obsuone komunikaty
             WM_COMMAND do funkcji DefFrameProc */
          return DefFrameProc(okno, klientMDI, 
                              komunikat, wParam, lParam);
      }
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      // przeka nie obsuone komunikaty do DefFrameProc 
      return DefFrameProc(okno, klientMDI, 
                          komunikat, wParam, lParam);
  }
}

LRESULT CALLBACK ProcDokumentu(HWND okno, UINT komunikat, 
                               WPARAM wParam, LPARAM lParam)
{
  /* W tym uproszczonym przypadku nie obsugujemy 
     adnych komunikatw okna dokumentu */
  return DefMDIChildProc(okno, komunikat, wParam, lParam);
}

