#include <windows.h>
#include <fstream.h>
#include "bmpview.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL Otworz(HWND, char *, int);
int WczytajBMP(char *, HWND);
int ObslugaSuwaka(WPARAM, int, int, int);
void UstawSuwaki(HWND okno);

// Uchwyt mapy DIB
HBITMAP hMapa = NULL;
// Uchwyt palety
HPALETTE hPaleta = NULL;
// Wymiary mapy bitowej
int SzerMapy,WysMapy;
// Ilo kolorw palety
int IloscKolorow;

// Pooenie suwakw paskw przewijania
int pozX=0, pozY=0;
// Zakres paskw przewijania
int maxX=0, maxY=0;

// Wymiary obszaru klienta okna
int szerOkna=0, wysOkna=0;

HINSTANCE zadanie;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR parametry, int trybOkna)
{                         
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = "Okno aplikacji";
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(zad, "ikona");
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;

  zadanie = zad;

  HWND okno = CreateWindowEx(WS_EX_CLIENTEDGE ,
                "Okno aplikacji", 
                "Pliki bmp", WS_OVERLAPPEDWINDOW
                | WS_VSCROLL | WS_HSCROLL,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  /* Sprawd, czy parametrem wywoania 
     programu nie jest nazwa pliku BMP */
  if(lstrlen(parametry)>4 && 
     !lstrcmpi(parametry+lstrlen(parametry)-4,".bmp") )
    // Wczytaj map bitow
    if(WczytajBMP(parametry, okno))
    {
      UstawSuwaki(okno);
      // Zmie tytu okna
      SetWindowText(okno, parametry);
    }
  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
      // Ustaw zakres paskw przewijania
      SetScrollRange(okno, SB_HORZ, 0, maxX, FALSE);
      SetScrollRange(okno, SB_VERT, 0, maxY, FALSE);
      return 0;
    case WM_SIZE:
      // Zapamitaj nowe rozmiary obszaru klienta okna
      szerOkna = LOWORD(lParam);
      wysOkna = HIWORD(lParam);
      /* Jeeli uytkownik otworzy plik BMP
         to ustaw na nowo zakres paskw przewijania*/
      if(hMapa)
        UstawSuwaki(okno);
      return 0;
    case WM_PAINT:
    {
      // Sprawd, czy jest wczytana mapa bitowa
      if(hMapa == NULL) return 0;
      // pobierz kontekst ekranu
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      // stwrz nowy kontekst
      HDC kontMapy = CreateCompatibleDC(kont);
      // umie map w kontekcie kontMapy
      SelectObject(kontMapy, hMapa);
	    
      // Wybierz palet do kontekstu
      HPALETTE hpalold=NULL;
      if(hPaleta)
      {
        hpalold=SelectPalette(kont,hPaleta,FALSE);
        RealizePalette(kont);
      }
      // Wywietl map bitow
      BitBlt(kont, 0, 0, SzerMapy, WysMapy,
             kontMapy, pozX, pozY, SRCCOPY);
      if(hpalold)
        SelectPalette(kont,hpalold,FALSE);
      // Zwolnij kontekst ekranu
      EndPaint(okno, &ps);
      // usu kontekst mapy bitowej
      DeleteDC(kontMapy); 
      return 0;
    }
    case WM_QUERYNEWPALETTE:
      if(hPaleta)
      {
        HDC kont = GetDC(okno);
        // Wybierz palet do kontekstu okna
        HPALETTE popPaleta = 
          SelectPalette(kont,hPaleta,FALSE);
        /* Odmaluj zawarto okna jeeli 
           jest to konieczne */
        if(RealizePalette(kont))
          InvalidateRect(okno, NULL, TRUE);
        // Przywr poprzedni palet do kontekstu okna
        SelectPalette(kont,popPaleta,FALSE);
        ReleaseDC(okno, kont);
      }
      return 0;
    case WM_PALETTECHANGED:
      if(((HWND)wParam != okno) && hPaleta)
      {
        HDC kont = GetDC(okno);
        // Wybierz palet do kontekstu okna
        HPALETTE popPaleta = 
          SelectPalette(kont,hPaleta,FALSE);
        /* Odmaluj zawarto okna jeeli 
           jest to konieczne */
        if(RealizePalette(kont))
          UpdateColors(kont);
        // Przywr poprzedni palet do kontekstu okna
        SelectPalette(kont,popPaleta,FALSE);
        ReleaseDC(okno, kont);
      }
      return 0;
    case WM_VSCROLL:
      pozY = ObslugaSuwaka(wParam, pozY, maxY, wysOkna/3);
      // Ustaw suwak w nowej pozycji
      SetScrollPos(okno, SB_VERT, pozY, TRUE);
      // Odmaluj zawarto okna 
      InvalidateRect(okno, NULL, FALSE);
      return 0;
    case WM_HSCROLL:
      pozX = ObslugaSuwaka(wParam, pozX, maxX, szerOkna/3);
      // Ustaw suwak w nowej pozycji
      SetScrollPos(okno, SB_HORZ, pozX, TRUE);
      // Odmaluj zawarto okna 
      InvalidateRect(okno, NULL, FALSE);
      return 0;
    case WM_COMMAND:
      if(LOWORD(wParam) == IDM_OTWORZ)
      {
        char plik[256];
        Otworz(okno, plik, 256);
        // Wczytaj map bitow
        if(WczytajBMP(plik, okno))
        {
          UstawSuwaki(okno);
          // Zmie tytu okna
          SetWindowText(okno, plik);
        }
        return 0;
      }
      return 0;
    case WM_DESTROY:
      // Usu palet
      if(hPaleta) DeleteObject(hPaleta);
      // Usu map bitow
      if(hMapa) DeleteObject(hMapa);
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Funkcja wywietla wsplne okno dialogowe Otwrz
BOOL Otworz(HWND okno, char *plik, int rozmiar)
{
  OPENFILENAME ofn;
  char szDirName[256];

  // Wpisz zero do bufora na nazw pliku
  plik[0] = 0;
  // Odczytaj biecy katalog
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  
  // Wypenij pola struktury ofn
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = okno;
  ofn.lpstrFilter = 
    "Pliki bmp\0*.bmp\0Wszystkie pliki\0*.*\0";
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= plik;
  ofn.nMaxFile = rozmiar;
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST 
              | OFN_FILEMUSTEXIST;
  ofn.hInstance = zadanie;
  return GetOpenFileName(&ofn); 
}

// Parametry wywoania funkcji WczytajBMP:
// NazwaPliku - nazwa (ewentualnie wraz ze
//              ciek dostpu) pliku BMP
// okno - uchwyt okna aplikacji
int WczytajBMP(char *NazwaPliku, HWND okno)
{
  //////////////// Wczytaj plik BMP //////////////// 
  
  // Otwrz plik
  ifstream ifs(NazwaPliku,ios::in | ios::binary);
  if(!ifs) return 0; // Bd otwarcia pliku

  // Przeczytaj nagwek pliku BMP
  BITMAPFILEHEADER bmphdr;
  ifs.read((unsigned char *)&bmphdr,
            sizeof(BITMAPFILEHEADER));
  if(bmphdr.bfType != (('M' << 8) | 'B')) 
    return 0; // To nie jest BMP!

  // Okrel rozmiar mapy DIB
  long bmpsize = bmphdr.bfSize - sizeof(BITMAPFILEHEADER);
  // Przydziel pami na map DIB
  char *mapaDIB = new char[bmpsize];
  if(!mapaDIB) return 0; // Bd przydziau pamici

  // Przeczytaj map DIB 
  ifs.read(mapaDIB,bmpsize);
  LPBITMAPINFOHEADER bmih = (LPBITMAPINFOHEADER)mapaDIB;
  
  /////////// Okrel wymiary i ilo kolorw /////////// 

  // Okrel wymiary mapy bitowej
  SzerMapy = bmih->biWidth;
  WysMapy = bmih->biHeight;

  // Okrel ilo kolorw mapy bitowej
  if(bmih->biClrUsed != 0) 
    IloscKolorow = (int)bmih->biClrUsed;
  else
    switch(bmih->biBitCount)
    {
      case 1: IloscKolorow = 2; break;
      case 4: IloscKolorow = 16; break;
      case 8: IloscKolorow = 256; break;
      default: IloscKolorow = 0; // Kolor 24-bitowy
    }

  //////////////// Twrz palet kolorw //////////////// 

  if(hPaleta) 
  {
    DeleteObject(hPaleta); 
    hPaleta = NULL;
  }
  if(IloscKolorow>0)
  {
    LPLOGPALETTE plog = (LPLOGPALETTE) 
      new unsigned char[sizeof(LOGPALETTE)
      + (IloscKolorow - 1) * sizeof(PALETTEENTRY)];
    if(plog)
    {
      plog->palVersion=0x0300;
      plog->palNumEntries=IloscKolorow;
      LPBITMAPINFO bmi = (LPBITMAPINFO) bmih;
      int i;
      for(i=0;i<IloscKolorow;i++)
      {
        plog->palPalEntry[i].peRed = 
          bmi->bmiColors[i].rgbRed;
        plog->palPalEntry[i].peGreen = 
          bmi->bmiColors[i].rgbGreen;
        plog->palPalEntry[i].peBlue = 
          bmi->bmiColors[i].rgbBlue;
        plog->palPalEntry[i].peFlags=0;
      }
      hPaleta=CreatePalette(plog);
      delete plog;
    }
  }

  //////////////// Twrz map DDB //////////////// 
  
  // Usu poprzedni map
  if(hMapa) DeleteObject(hMapa);
  // Wyznacz adres danych pikseli
  LPSTR dane = (LPSTR)mapaDIB
    + sizeof(BITMAPINFOHEADER)
    + sizeof(RGBQUAD)*IloscKolorow;

  // Wybierz palet do kontekstu okna
  HPALETTE popPaleta=NULL;
  HDC kont = GetDC(okno);
  if(hPaleta)
  {
    popPaleta = SelectPalette(kont, hPaleta, FALSE);
    RealizePalette(kont);
  }
  // Twrz map DDB
  hMapa=CreateDIBitmap(kont,bmih,CBM_INIT,dane,
	(LPBITMAPINFO)bmih,DIB_RGB_COLORS);
  // Przywr poprzedni palet do kontekstu
  if(popPaleta)
    SelectPalette(kont, popPaleta, FALSE);
  
  ReleaseDC(okno, kont);
  delete mapaDIB;
  return 1;
}

/* Funkcja ObslugaSuwaka zwraca now pozycj suwaka, 
   obliczon na podstawie jego poprzedniego pooenia,
   wartoci parametru wParam, rozmiaru strony,
   oraz podanego zakresu max */
int ObslugaSuwaka(WPARAM wParam, int poz, 
                  int max, int strona)
{ 
  switch(LOWORD(wParam))
  {
    case SB_BOTTOM:         poz = 0; break;
    case SB_TOP:            poz = max; break;
    case SB_LINEDOWN:       poz ++; break;
    case SB_LINEUP:         poz --; break; 
    case SB_PAGEDOWN:       poz += strona; break;
    case SB_PAGEUP:         poz -= strona; break;
    case SB_THUMBPOSITION:  poz = HIWORD(wParam); break;
    case SB_THUMBTRACK:     poz = HIWORD(wParam); break;
  }
  /* Sprawd, czy pozycja suwaka nie przekroczya 
     przedziau od 0 do max */
  if (poz < 0) poz = 0;
  if (poz > max) poz = max;

  return poz;
}

/* Funkcja ustawia zakres paskw przewijania
   zalenie od wielkoci okna i mapy bitowej */
void UstawSuwaki(HWND okno)
{
  // Wylicz zakres paskw przewijania
  if(SzerMapy > szerOkna)
    maxX = SzerMapy - szerOkna;
  else
    maxX = 0;
  if(WysMapy > wysOkna)
    maxY = WysMapy - wysOkna;
  else
    maxY = 0;
  // Ustaw zakres paskw przewijania
  SetScrollRange(okno, SB_HORZ, 0, maxX, FALSE);
  SetScrollRange(okno, SB_VERT, 0, maxY, FALSE);
  // Ustaw pooenia suwakw
  SetScrollPos(okno, SB_HORZ, 0, TRUE);
  SetScrollPos(okno, SB_VERT, 0, TRUE);
  pozX = pozY = 0;
  // Wywietl map bitow
  InvalidateRect(okno, NULL, TRUE);
}
