#include <windows.h>
#include <commctrl.h>
#include "Dialog.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
// Zmienne przechowujce wybrany kolor i jasno
int kolor=0, jasnosc=10;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Mj program", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      // Oblicz warto koloru
      int kol = (jasnosc*10)<<(kolor*8);
      // Twrz pdzel o zadanym kolorze
      HBRUSH pedzel = CreateSolidBrush(kol);
      // Wypenij to okna stworzonym pdzlem
      FillRect(kont, &ps.rcPaint, pedzel);
      DeleteObject(pedzel);
      EndPaint(okno, &ps);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    case WM_COMMAND:
      // Wybrano polecenie Kolor z menu
      if(LOWORD(wParam) == IDM_KOLOR)
        // Wywietl okno dialogowe
        if(DialogBox(zadanie, "DIALOG_1", okno, 
           (DLGPROC)ProcDialogu))
          /* Odmaluj to okna jeeli uytkownik 
             nacisn przycisk OK */
          InvalidateRect(okno, NULL, TRUE);
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Procedura dialogu
BOOL CALLBACK ProcDialogu(HWND dialog, UINT komunikat,
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
      // Ustaw zakres paska przesuwnego na 0-25
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETRANGE, TRUE, MAKELONG(0,25));
      /* Ustaw pozycj suwaka zalenie 
         od aktualnej jasnoci */
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETPOS, (WPARAM)TRUE, jasnosc);
      /* Zaznacz przycisk radiobutton odpowiadajcy
         aktualnie wybranemu kolorowi */
      switch(kolor)
      {
        case 0: 
          CheckDlgButton(dialog, ID_CZERWONY, BST_CHECKED);
          break;
        case 1: 
          CheckDlgButton(dialog, ID_ZIELONY, BST_CHECKED);
          break;
        case 2: 
          CheckDlgButton(dialog,ID_NIEBIESKI, BST_CHECKED);
          break;
      }
      return TRUE;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case ID_OK: // Nacinito przycisk OK
          /* Odczytaj, ktry przycisk koloru
             jest wybrany */
          if(IsDlgButtonChecked(dialog,ID_CZERWONY))
            kolor = 0;
          else if(IsDlgButtonChecked(dialog,ID_ZIELONY))
            kolor = 1;
          else if(IsDlgButtonChecked(dialog,ID_NIEBIESKI))
            kolor = 2;
          // Odczytaj jasno koloru 
          jasnosc = SendDlgItemMessage(dialog, ID_JASNOSC, 
                                       TBM_GETPOS, 0, 0);
          EndDialog(dialog, TRUE);
          return TRUE;
        case ID_ANULUJ:
          EndDialog(dialog, FALSE);
          return TRUE;
      }
      return FALSE;
    case WM_CLOSE:
      EndDialog(dialog, FALSE);
      return TRUE;
  }
  return FALSE;
}
