#include <windows.h>
#include <commctrl.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Uchwyt drzewa
HWND hTreeView;
// Tablica uchwytw gazi i lici drzewa
HTREEITEM hTreeViewItem[13];
// uchwyt listy obrazw
HIMAGELIST hImageList;
/* uchwyt mapy bitowej zawierajcej obrazki 
   wstawiane do listy */
HBITMAP hMapa;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = CS_HREDRAW | CS_VREDRAW;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = 
       (HBRUSH)GetStockObject(WHITE_BRUSH);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "TreeView", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      /* Tablica przechowujca nazwy wszystkich elementw 
         drzewa, wykorzystywana przy jego tworzeniu */
      char *text[13] = { "Ga 1", "Li 1", "Li 2",
                         "Podga 1", "Li 1", "Li 2",
                         "Ga 2", "Li 1", "Li 2", 
                         "Ga 3", "Li 1", "Li 2", "Li 3"};
      /* Gazie-rodzice lici i podgazi drzewa,
         -1 oznacza korze gwny */
      int parent[13] = { -1, 0, 0, 0, 3, 3, -1, 
                          6, 6, -1, 9, 9, 9};
      // Indeksy obrazkw poszczeglnych elementw drzewa
      int image[13] = { 0, 1, 3, 2, 4, 4, 0, 1, 
                        3, 0, 1, 2, 3 };
      TV_INSERTSTRUCT tvInsStr;
      TV_ITEM tviItem;
      
      // Twrz list obrazw
      hImageList = ImageList_Create(16, 16, ILC_COLOR, 5, 0);
      // aduj map bitow z zasobw programu
      hMapa = LoadBitmap( zadanie, "mapa1");
      // i umie obrazki w licie
      ImageList_Add(hImageList, hMapa, NULL);
      DeleteObject(hMapa);

      hTreeView = CreateWindowEx(WS_EX_CLIENTEDGE, WC_TREEVIEW, "",
            WS_CHILD | WS_VISIBLE | TVS_HASLINES | 
            TVS_HASBUTTONS | TVS_LINESATROOT | TVS_EDITLABELS, 
            0, 0, 200, 250, okno, NULL, zadanie, NULL);
      
      // Powi list z drzewem
      TreeView_SetImageList(hTreeView, (WPARAM)hImageList,
                            TVSIL_NORMAL);

      // Twrz gazie i licie drzewa 
      tviItem.mask = TVIF_TEXT | TVIF_IMAGE | 
                     TVIF_SELECTEDIMAGE;
      tvInsStr.hInsertAfter = TVI_SORT;
      for(int i=0; i<13; i++)
      {
        /* Inicjuj pola wskazujce tekst, rodzica oraz 
           obrazek wstawianego licia */
        tviItem.pszText = text[i];
        if(parent[i]==-1)
          tvInsStr.hParent = TVI_ROOT;
        else
          tvInsStr.hParent = hTreeViewItem[parent[i]];
        tviItem.iSelectedImage = tviItem.iImage = image[i];
        tvInsStr.item = tviItem;
        // Wstaw li do drzewa
        hTreeViewItem[i] = 
          TreeView_InsertItem(hTreeView, &tvInsStr);
      }
      return 0;
    }
    case WM_SIZE:
      // Dostosuj wysoko drzewa do wysokoci okna
      MoveWindow(hTreeView, 0, 0, 200, HIWORD(lParam), TRUE);
      return 0;
    case WM_NOTIFY:
      if(((LPNMHDR)lParam)->hwndFrom == hTreeView)
        switch(((LPNMHDR)lParam)->code)
        {
          /* Uytkownik wprowadzi now nazw 
             dla elementu drzewa */
          case TVN_ENDLABELEDIT:
            // Jeeli nie nacinito ESC
            if(((TV_DISPINFO *)lParam)->item.pszText != NULL  )
            {
              // Ustaw mask na zmian tekstu
              ((TV_DISPINFO *)lParam)->item.mask = TVIF_TEXT;
              /* Zmie tekst elementu drzewa na nowy 
                 wprowadzony przez uytkownika */
              TreeView_SetItem(hTreeView,
                  &(((TV_DISPINFO *)lParam)->item) ); 
              // Wywietl nowy tekst w pasku tytuowym okna
              SendMessage(okno, WM_SETTEXT, 0, 
                (LPARAM)((TV_DISPINFO *) lParam)->item.pszText);
            }
            break;
          // Wybrany zosta nowy element drzewa
          case TVN_SELCHANGED:
          {
            // bufor na odczytywany tekst 
            char bufor[100];
            // Ustaw mask na odczyt tekstu
            ((NM_TREEVIEW *)lParam)->itemNew.mask = TVIF_TEXT;
            // Ustaw adres bufora
            ((NM_TREEVIEW *)lParam)->itemNew.pszText = bufor;
            // Ustaw dugo bufora
            ((NM_TREEVIEW *)lParam)->itemNew.cchTextMax = 100;
            // Odczytaj tekst do bufora
            TreeView_GetItem(hTreeView, 
              &((NM_TREEVIEW *)lParam)->itemNew );
            // Wywietl tekst w pasku tytuowym okna
            SendMessage(okno, WM_SETTEXT, 0, (LPARAM)bufor);
            break;
          }
        }
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
