#include <windows.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HMENU hSysMenu;  // Uchwyt podmenu
HINSTANCE zadanie;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;
  HWND okno = CreateWindowEx(0, nazwaKlasy, 
                "Menu systemowe", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  // Wywietl okno
  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      HMENU hSysMenu = GetSystemMenu(okno, FALSE);
      DeleteMenu(hSysMenu, 0, MF_BYPOSITION);
      DeleteMenu(hSysMenu, 0, MF_BYPOSITION);
      InsertMenu(hSysMenu, 0, MF_BYPOSITION | MF_BITMAP, 
                 100, (LPSTR)LoadBitmap(zadanie, "mapa1"));
      InsertMenu(hSysMenu, 1, MF_BYPOSITION | 
                 MF_SEPARATOR, 0, NULL);
      return 0;
    }
    case WM_SYSCOMMAND:
      if (LOWORD(wParam) == 100)
      {
        MessageBox(okno, "Informacja o programie", "", MB_OK);
        break;
      }
      else
        return DefWindowProc(okno, komunikat, 
                             wParam, lParam);
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      break;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
  return 0;
}
