// Szeroko pionowego paska
#define SZER 44;
// i wysoko poziomego
#define WYS 44;
// Maksymalna ilo ikon na pasku
#define MAX 20

#include <windows.h>
#include <commctrl.h>
#include "Pulpit.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu(HWND, UINT, WPARAM, LPARAM);
void Menu(WPARAM, LPARAM);
void UluzPrzyciski();
void Rozmiesc();
void TworzListeIkon();
void ZamienPrzyciski(int);
void PrzesunwGore(HWND);
void PrzesunwDol(HWND);
void DodajPrzycisk(char*);
void UsunPrzyciski(HWND);
void WstawPrzycisk(HWND, HWND);
void WypelnijListe(HWND);
void Odczytaj();
void Zapisz();
void ZapiszPolozenie();

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Pooenie paska na pulpicie
int polozenie;
// Aktualnie wybrana pozycja podmenu Pooenie
int pozMenu;

/* Uchwyt menu wywietlanego po klikniciu 
   prawym przyciskiem myszki na pasku */
HMENU hMenu;

// Lista obrazw zawierajca ikony 
HIMAGELIST hIkony;
// Ilo ikon/przyciskw
int iloscIkon = 0;

// Uchwyty przyciskw
HWND Przyciski[MAX];
// cieki programw i/lub dokumentw
char Programy[MAX][256];

// Uchwyt paska
HWND Okno;

/* Mapy bitowe wywietlane na przyciskach 
   okna dialogowego Ikony */
HBITMAP mapa1, mapa2;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
    		    LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(zadanie, "ikona");
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_MENU+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  // Inicjalizuj uycie wsplnych obiektw sterujcych
  InitCommonControls();

  hMenu = GetSubMenu(LoadMenu(zadanie,"menu1"),0);

  // Stwrz okno
  Okno = CreateWindowEx(WS_EX_TOOLWINDOW,
                nazwaKlasy, "", 
                WS_POPUP | WS_DLGFRAME, 0, 0, 0, 0,
                NULL, NULL, zad, NULL);
  if(!Okno) return 0;

  /* Odczytaj z rejestru informacje 
     o przyciskach i pooeniu paska */
  Odczytaj();
  
  // Ustal pooenie paska
  Rozmiesc();

  ShowWindow(Okno,SW_SHOWNORMAL);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Akceptuj przeciganie plikw
      DragAcceptFiles(okno, TRUE);
      
      // Zarejestruj pasek pulpitu
      APPBARDATA abd;
      abd.cbSize = sizeof(APPBARDATA);
      abd.hWnd = okno;
      abd.uCallbackMessage = WM_USER;
      if(!SHAppBarMessage(ABM_NEW, &abd))
        return -1;

      // Twrz list obrazw
      hIkony = ImageList_Create(32, 32, ILC_COLOR, 0, 0);
      ImageList_SetBkColor(hIkony, RGB(255,255,255));

      /* aduj mapy bitowe wywietlane na 
         przyciskach okna dialogowego Ikony */
      mapa1 = LoadBitmap(zadanie, "bitmap1");
      mapa2 = LoadBitmap(zadanie, "bitmap2");
      return 0;
    }
    case WM_DROPFILES:
    {
      // bufor na nazw pliku
      char bufor[256];
      // Pobierz ilo przecignitych plikw
      int n = DragQueryFile((HDROP)wParam, 
                            0xFFFFFFFF, NULL, 0); 
      // Pobierz kolejno nazwy wszystkich plikw
      for(int i=0; i<n; i++)
      {
        DragQueryFile((HDROP)wParam, i, bufor, 256);
        // Dodaj przycisk dla przecignitego pliku
        DodajPrzycisk(bufor);
      }
      DragFinish((HDROP)wParam);
      // Zapisz informacje o przyciskach do rejestru
      Zapisz();
      return 0;
    }
    case WM_USER:
      if(wParam == ABN_POSCHANGED)
        // Ustal now pozycj paska
        Rozmiesc();
      return 0;
    case WM_ACTIVATE:
    {
      // Poinformuj system o aktywacji paska
      APPBARDATA abd;
      abd.cbSize = sizeof(APPBARDATA);
      abd.hWnd = okno;
      SHAppBarMessage(ABM_ACTIVATE, &abd);
      return 0;
    }
    case WM_WINDOWPOSCHANGED:
    {
      // Poinformuj system o zmianie pooenia paska
      APPBARDATA abd;
      abd.cbSize = sizeof(APPBARDATA);
      abd.hWnd = okno;
      SHAppBarMessage(ABM_WINDOWPOSCHANGED, &abd);
      return 0;
    }
    case WM_RBUTTONDOWN:
    {
      POINT punkt;
      punkt.x = LOWORD(lParam);
      punkt.y = HIWORD(lParam);
      /* Konwertuj wsprzdne kursora myszki 
         na wsprzdne ekranowe */
      ClientToScreen(okno, &punkt);
      // Wywietl menu
      TrackPopupMenu(hMenu, TPM_RIGHTBUTTON, 
          punkt.x, punkt.y, 0, okno, NULL);
      return 0;
    }
    case WM_COMMAND:
      /* Uytkownik wybra polecenie z menu
         lub klikn na przycisku */
      Menu(wParam, lParam);
      return 0;
    case WM_DESTROY:
    {
      // Wyrejestruj pasek pulpitu
      APPBARDATA abd;
      abd.cbSize = sizeof(APPBARDATA);
      abd.hWnd = okno;
      SHAppBarMessage(ABM_REMOVE, &abd);
      // Usu mapy bitowe
      DeleteObject(mapa1);
      DeleteObject(mapa2);
      for(int i=0; i<iloscIkon; i++)
        DeleteObject((HBITMAP)SendMessage(Przyciski[i], 
                                  BM_GETIMAGE, 0, 0));
      // Zakocz program
      PostQuitMessage(0); 
      return 0;
    }
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

/* Obsuga przyciskw paska oraz menu 
   wywietlanego po naciniciu prawego 
   klawisza myszki na pasku */
void Menu(WPARAM wParam, LPARAM lParam)
{
  // Sprawd czy uytkownik wybra przycisk
  if(LOWORD(wParam) >= 200 && 
     LOWORD(wParam) < 200 + iloscIkon)
  {
    // Uruchom program zwizany z danym przyciskiem
    ShellExecute(Okno, "open", 
      Programy[LOWORD(wParam) - 200],
      NULL, NULL, SW_SHOW);
    return;
  }
  // Uytkownik wybra polecenie z menu
  switch(LOWORD(wParam))
  {
    case IDM_IKONY:
      DialogBox(zadanie, "DIALOG_1", Okno, 
         (DLGPROC)ProcDialogu);
      Zapisz();
      return;
    case IDM_ZAMKNIJ:
      DestroyWindow(Okno); // Zakocz program
      return;
    // Zmiana pooenia na ekranie paska zada 
    case IDM_GORA:  polozenie = ABE_TOP; break;
    case IDM_DOL:   polozenie = ABE_BOTTOM; break;
    case IDM_LEWA:  polozenie = ABE_LEFT; break;
    case IDM_PRAWA: polozenie = ABE_RIGHT; break;
    default:        return;
  }
      
  // Jeeli zmienio si pooenie paska
  if(LOWORD(wParam) != pozMenu)
  {
    // Zaznacz wybran pozycj w menu 
    CheckMenuItem(hMenu, pozMenu, MF_UNCHECKED);
    pozMenu = LOWORD(wParam);
    CheckMenuItem(hMenu, pozMenu, MF_CHECKED);
    
    UluzPrzyciski();
    Rozmiesc();
    // Zapisz informacje o pooeniu paska do rejestru
    ZapiszPolozenie();
  }
}

/* Procedura ukada przyciski pionowo lub poziomo
   w zalenoci od uoenia paska */
void UluzPrzyciski()
{
  int x = 0, y = 0;
  for(int i=0; i<iloscIkon; i++)
  {
    MoveWindow(Przyciski[i], x, y, 38, 38, TRUE);
    if(polozenie == ABE_TOP || polozenie == ABE_BOTTOM)
      x += 40;
    else
      y += 40;
  }
}

/* Funkcja ustala nowe pooenie paska 
   i przesuwa go do niego */
void Rozmiesc()
{
  APPBARDATA abd;
  abd.cbSize = sizeof(APPBARDATA);
  abd.hWnd = Okno;
  abd.uEdge = polozenie;

  /* Wpisz domylne pooenie oraz rozmiar 
     paska do pola rc struktury APPBARDATA */
  abd.rc.top = 0;
  abd.rc.left = 0;
  abd.rc.bottom = GetSystemMetrics(SM_CYSCREEN);
  abd.rc.right = GetSystemMetrics(SM_CXSCREEN);

  switch(polozenie)
  {
    case ABE_TOP:
      abd.rc.bottom = abd.rc.top + WYS; break;
    case ABE_LEFT:
      abd.rc.right = abd.rc.left + SZER; break;
    case ABE_BOTTOM:
      abd.rc.top = abd.rc.bottom - WYS; break;
    case ABE_RIGHT:
      abd.rc.left = abd.rc.right - SZER; break;
  }

  /* Wyznacz rzeczywiste pooenie
     oraz rozmiar paska */
  SHAppBarMessage(ABM_QUERYPOS, &abd);

  switch(polozenie)
  {
    case ABE_TOP:
      abd.rc.bottom = abd.rc.top + WYS; break;
    case ABE_LEFT:
      abd.rc.right = abd.rc.left + SZER; break;
    case ABE_BOTTOM:
      abd.rc.top = abd.rc.bottom - WYS; break;
    case ABE_RIGHT:
      abd.rc.left = abd.rc.right - SZER; break;
  }
  /* Przeka do systemu obszar 
     ekranu zajty przez pasek */
  SHAppBarMessage(ABM_SETPOS, &abd);

  // Przesu pasek do zadanego pooenia
  MoveWindow(Okno, abd.rc.left, abd.rc.top,
             abd.rc.right - abd.rc.left,
             abd.rc.bottom - abd.rc.top,
             TRUE);
}

// Procedura okna dialogowego "Ikony"
BOOL CALLBACK ProcDialogu(HWND dialog, UINT komunikat,
                          WPARAM wParam, LPARAM lParam)
{
  // Pobierz uchwyt listy-widoku
  HWND lista = GetDlgItem(dialog, ID_LISTVIEW);
  switch(komunikat)
  {
    case WM_INITDIALOG:
    {
      // Przypisz list obrazw do listy-widoku
      ListView_SetImageList(lista, hIkony, LVSIL_SMALL);
      // Wstaw etykiety do listy-widoku
      WypelnijListe(lista);
      // Wywietl mapy bitowe na dwch przyciskach
      SendDlgItemMessage(dialog, ID_GORA, BM_SETIMAGE, 
                         0, (LPARAM)mapa1);
      SendDlgItemMessage(dialog, ID_DOL, BM_SETIMAGE, 
                         0, (LPARAM)mapa2);
      return TRUE;
    }
    case WM_COMMAND:
      // Obsuga przyciskw
      switch(LOWORD(wParam))
      {
        case ID_GORA:
          PrzesunwGore(lista);
          break;
        case ID_DOL:
          PrzesunwDol(lista);
          break;
        case ID_USUN:
          UsunPrzyciski(lista);
          break;
        case ID_DODAJ:
          WstawPrzycisk(dialog, lista);
          break;
        case IDOK:
          EndDialog(dialog, TRUE);
          break;
      }
      return TRUE;
    case WM_CLOSE:
      EndDialog(dialog, FALSE);
      return TRUE;
  }
  return FALSE;
}

/* Funkcja tworzy list ikon
   programw i dokumentw */
void TworzListeIkon()
{
  HICON ikona;
  WORD indeks;
  // Usu dotychczasowe ikony z listy
  ImageList_RemoveAll(hIkony);
  // Wstaw do listy ikony
  for(int i=0; i<iloscIkon; i++)
  {
    indeks = 0;
    ikona = ExtractAssociatedIcon(zadanie, 
      Programy[i], &indeks);
    ImageList_AddIcon(hIkony, ikona);
    DeleteObject(ikona);
  }
}

// Funkcja zamienia miejscami dwa ssiednie przyciski
void ZamienPrzyciski(int i)
{
  char buf[256];
  HWND przycisk;

  przycisk = Przyciski[i];
  Przyciski[i] = Przyciski[i+1];
  Przyciski[i+1] = przycisk;
      
  lstrcpy(buf, Programy[i]);
  lstrcpy(Programy[i], Programy[i+1]);
  lstrcpy(Programy[i+1], buf);

  /* Wyznacz na nowo identyfikatory 
     zamienianych przyciskw */
  SetWindowLong(Przyciski[i], GWL_ID, 200+i);
  SetWindowLong(Przyciski[i+1], GWL_ID, 201+i);
}

/* Funkcja przesuwa wszystkie zaznaczone 
   ikony o jedno miejsce w gr 
   (w lewo przy poziomym pasku). */
void PrzesunwGore(HWND lista)
{
  int i;
  for(i=1; i<iloscIkon; i++)
    /* jeeli dana etykieta w licie jest zaznaczona
       to zamie przyciski */
    if(ListView_GetItemState(lista, i, LVIS_SELECTED))
      ZamienPrzyciski(i-1);

  // Wywietl przyciski w nowej kolejnoci
  UluzPrzyciski();  
  // Twrz now list ikon
  TworzListeIkon();
  // Wypenij na nowo list-widok
  ListView_DeleteAllItems(lista);
  WypelnijListe(lista);
}

/* Funkcja przesuwa wszystkie zaznaczone 
   ikony o jedno miejsce w d
   (w prawo przy poziomym pasku). */
void PrzesunwDol(HWND lista)
{
  int i;
  for(i=iloscIkon-2; i>=0; i--)
    /* jeeli dana etykieta w licie jest zaznaczona
       to zamie przyciski */
    if(ListView_GetItemState(lista, i, LVIS_SELECTED))
      ZamienPrzyciski(i);

  // Wywietl przyciski w nowej kolejnoci
  UluzPrzyciski();  
  // Twrz now list ikon
  TworzListeIkon();
  // Wypenij na nowo list-widok
  ListView_DeleteAllItems(lista);
  WypelnijListe(lista);
}

/* Funkcja dodaje przycisk do paska oraz tworzy 
   wywietlan w nim map bitow z ikony programu */
void DodajPrzycisk(char *plik)
{
  if(iloscIkon == MAX) return;

  /* Odczytaj ikon z programu, lub ikon 
     zwizan z danym typem dokumentu */
  WORD indeks = 0;
  HICON ikona = 
    ExtractAssociatedIcon(zadanie, plik, &indeks);
  
  // Dodaj ikon do listy obrazw
  ImageList_AddIcon(hIkony, ikona);
  
  // Twrz map bitow zawierajc rysunek ikony
  // Pobierz kontekst ekranu
  HDC kont = GetDC(Okno);
  // Stwrz zgodn z nim map 
  HBITMAP mapa = CreateCompatibleBitmap(kont, 32, 32);
  // Stwrz nowy kontekst
  HDC kontMapy = CreateCompatibleDC(kont);
  // Umie map w kontekcie kontMapy
  SelectObject(kontMapy, mapa);
  // Wypenij map bitow szarym pdzlem
  RECT prost = {0, 0, 32, 32};
  FillRect(kontMapy, &prost, (HBRUSH) (COLOR_MENU+1));
  // Rysuj ikon na mapie bitowej
  DrawIcon(kontMapy, 0, 0, ikona);
  DeleteDC(kontMapy);
  ReleaseDC(Okno, kont);
  DeleteObject(ikona);

  // Wyznacz wsprzdne nowego przycisku
  int x = 0, y = 0;
  if(polozenie == ABE_TOP || polozenie == ABE_BOTTOM)
    x = iloscIkon*40;
  else
    y = iloscIkon*40;

  // Twrz przycisk
  Przyciski[iloscIkon] = CreateWindow("BUTTON", NULL, 
    BS_PUSHBUTTON | BS_BITMAP | WS_CHILD | WS_VISIBLE,
    x, y, 38, 38, Okno, (LPVOID)(200 + iloscIkon), 
    zadanie, NULL);
  // Wywietl map bitow w przycisku
  SendMessage(Przyciski[iloscIkon], BM_SETIMAGE, 
              0, (LPARAM)mapa);
  // Zapamitaj ciek programu (dokumentu)
  lstrcpy(Programy[iloscIkon], plik);
  
  iloscIkon ++;
}

/* Funkcja usuwa przyciski odpowiadajce 
   zaznaczonym w licie-widoku etykietom */
void UsunPrzyciski(HWND lista)
{
  int i = 0; // Licznik przyciskw
  int k; // Licznik etykiet w licie-widoku
  int il = iloscIkon; // Ilo etykiet w licie-widoku
  for(k=0; k<il; k++)
  {
    if(ListView_GetItemState(lista, k, LVIS_SELECTED))
    {  
      // Usu map bitow wywietlan w przycisku
      DeleteObject((HBITMAP)SendMessage(Przyciski[i], 
                    BM_GETIMAGE, 0, 0));
      // Usu przycisk;
      DestroyWindow(Przyciski[i]);
      // Przesu nastpne przyciski w lewo
      for(int j=i; j<iloscIkon-1; j++)
      {
        lstrcpy(Programy[j],Programy[j+1]);
        Przyciski[j] = Przyciski[j+1];
        SetWindowLong(Przyciski[j],GWL_ID,200+j);
      }
      iloscIkon--;
    }
    else
      i++;
  }
  // Wywietl przyciski w nowej kolejnoci
  UluzPrzyciski();  
  // Twrz now list ikon
  TworzListeIkon();
  // Wypenij na nowo list-widok
  ListView_DeleteAllItems(lista);
  WypelnijListe(lista);
}

/* Funkcja wywietla wsplne okno dialogowe 
   Otwrz i po wybraniu przez uytkownika 
   pliku tworzy dla niego nowy przycisk */
void WstawPrzycisk(HWND dialog, HWND lista)
{
  if(iloscIkon == MAX)
  {
    MessageBox(dialog, 
      "Nie mog wstawi wicej ikon", "Uwaga!", MB_OK);
    return;
  }
  
  OPENFILENAME ofn;
  char szDirName[256];
  char plik[256] = "\0";
  // Odczytaj biecy katalog
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  
  // Wypenij pola struktury ofn
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = dialog;
  ofn.lpstrFilter = NULL;
  ofn.nFilterIndex = 0;
  ofn.lpstrFile= plik;
  ofn.nMaxFile = 256;
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST 
     | OFN_FILEMUSTEXIST;

  if(!GetOpenFileName(&ofn))
    return;

  // Stwrz nowy przycisk
  DodajPrzycisk(plik);

  // Wstaw now etykiet do listy
  LV_ITEM lvi;
  lvi.mask = LVIF_IMAGE | LVIF_TEXT;
  lvi.iSubItem = 0;
  lvi.iImage = iloscIkon-1;
  lvi.iItem = iloscIkon-1;
  lvi.pszText = Programy[iloscIkon-1];
  ListView_InsertItem(lista, &lvi);
}

// Funkcja wstawia etykiety do listy-widoku 
void WypelnijListe(HWND lista)
{
  LV_ITEM lvi;
  for(int i=0; i<iloscIkon; i++)
  {
    lvi.mask = LVIF_IMAGE | LVIF_TEXT;
    lvi.iSubItem = 0;
    lvi.iImage = i;
    lvi.iItem = i;
    lvi.pszText = Programy[i];
    ListView_InsertItem(lista, &lvi);
  }
}

/* Funkcja odczytuje informacje o przyciskach 
   i pooeniu paska z rejestru */
void Odczytaj()
{
  HKEY klucz;
  char nazwa[10];
  char plik[256];
  DWORD rozm = 4;
  // Otwrz odpowiedni klucz rejestru
  if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
      "SOFTWARE\\AppPulpitu\\Pooenie", 0,
      KEY_QUERY_VALUE, &klucz) == ERROR_SUCCESS)
  {
    // Odczytaj informacje o pooeniu paska
    if(RegQueryValueEx(klucz, "Krawd", 0, NULL, 
           (BYTE *)&polozenie, &rozm)          
           != ERROR_SUCCESS)
      polozenie = ABE_LEFT;
    // Zamknij otwarty klucz rejestru 
    RegCloseKey(klucz);
  }
  else 
    polozenie = ABE_LEFT;
  
  switch(polozenie)
  {
    case ABE_BOTTOM: pozMenu = IDM_DOL; break;
    case ABE_TOP: pozMenu = IDM_GORA; break;
    case ABE_RIGHT: pozMenu = IDM_PRAWA; break;
    default: polozenie = ABE_LEFT;
             pozMenu = IDM_LEWA;
  }
  CheckMenuItem(hMenu, pozMenu, MF_CHECKED);

  // Otwrz odpowiedni klucz rejestru
  if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
      "SOFTWARE\\AppPulpitu\\Ikony", 0,
      KEY_QUERY_VALUE, &klucz) != ERROR_SUCCESS)
    return;
  // Odczytaj cieki programw odpowiadajcych przyciskom
  for(int i=0; i<MAX; i++)
  {
    wsprintf(nazwa, "Ikona %d", i+1);
    rozm = 256;
    if(RegQueryValueEx(klucz, nazwa, 0, NULL, 
         (unsigned char *)plik, &rozm) 
         != ERROR_SUCCESS)
      break;
    DodajPrzycisk(plik);
  }
  // Zamknij otwarty klucz rejestru 
  RegCloseKey(klucz);
}

// Funkcja zapisuje informacje o przyciskach do rejestru
void Zapisz()
{
  HKEY klucz;
  DWORD akcja;
  char nazwa[10];
  // Otwrz odpowiedni klucz rejestru
  RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
    "SOFTWARE\\AppPulpitu\\Ikony", 0, NULL,
    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
    &klucz, &akcja);
  // Zapisz cieki programw odpowiadajcych przyciskom
  for(int i=0; i<MAX; i++)
  {
    wsprintf(nazwa, "Ikona %d", i+1);
    if(i<iloscIkon)
      RegSetValueEx(klucz, nazwa, 0, REG_SZ,
        (const unsigned char *)Programy[i], 
        lstrlen(Programy[i])+1);
    else
      // Usu pozostae wartoci jeeli istniej
      if(RegDeleteValue(klucz, nazwa)
          != ERROR_SUCCESS)
        break;
  }
  // Zamknij otwarty klucz rejestru 
  RegCloseKey(klucz);
}

/* Funkcja zapisuje informacje o 
   pooeniu paska do rejestru */
void ZapiszPolozenie()
{
  HKEY klucz;
  DWORD akcja;
  // Otwrz odpowiedni klucz rejestru
  RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
    "SOFTWARE\\AppPulpitu\\Pooenie", 0, NULL,
    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL,
    &klucz, &akcja);
  // Zapisz informacje o pooeniu paska
  RegSetValueEx(klucz, "Krawd", 0, REG_DWORD,
        (CONST BYTE *)&polozenie, 4);
  // Zamknij otwarty klucz rejestru 
  RegCloseKey(klucz);
}
