#include <windows.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  // Rejestruj okno w systemie
  if(!RegisterClass(&klasaOkna)) return 0;

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Mj program", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
      // Akceptuj przeciganie plikw
      DragAcceptFiles(okno, TRUE);
      return 0;
    case WM_DROPFILES:
    {
      // bufor na nazw pliku
      char bufor[256];
      // Pobierz ilo przecignitych plikw
      UINT n = DragQueryFile((HDROP)wParam, -1, NULL, 0); 
      // Pobierz kolejno nazwy wszystkich plikw
      for(int i=0; i<n; i++)
      {
        DragQueryFile((HDROP)wParam, i, bufor, 256);
        MessageBox(okno, bufor, 
                   "Przecignity plik", MB_OK);
      }
      // Zakocz obsug komunikatu
      DragFinish((HDROP)wParam);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
