#include <windows.h>
#include <commctrl.h>
#include <string.h>
#include "Zakladki.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu1(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu2(HWND, UINT, WPARAM, LPARAM);

void Odczytaj1(HWND);
void Odczytaj2(HWND);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Uchwyt obiektu zakadki
HWND hTab;

// Uchwyty okien dialogowych wywietlanych w zakadkach
HWND hDialog1,hDialog2;
// Uchwyt dialogu wywietlanego w wybranej zakadce
HWND hDialog;
// Indeks aktualnie wybranej zakadki
int zakladka;

// Zmienne przechowujce wybrany kolor i jasno,
int kolor=0, jasnosc=10;
// tytu okna,
char tytul[80];
// jego wielko,
int wielkosc = 1;
// oraz informacje o obecnoci paskw przewijania
BOOL pionowy = TRUE, poziomy = TRUE;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  InitCommonControls();

  strcpy(tytul, "Mj program");
  HWND okno = CreateWindowEx(0,nazwaKlasy, tytul, 
                WS_OVERLAPPEDWINDOW 
                | WS_HSCROLL | WS_VSCROLL,
                100, 50, 400, 300,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    if(!IsDialogMessage(hDialog, &komunikat))
    {
      TranslateMessage(&komunikat);
      DispatchMessage(&komunikat);
    }
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      // Oblicz warto koloru
      int kol = (jasnosc*10)<<(kolor*8);
      // Twrz pdzel o zadanym kolorze
      HBRUSH pedzel = CreateSolidBrush(kol);
      // Wypenij to okna stworzonym pdzlem
      FillRect(kont, &ps.rcPaint, pedzel);
      DeleteObject(pedzel);
      EndPaint(okno, &ps);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    case WM_COMMAND:
      // Wybrano polecenie Opcje z menu
      if(LOWORD(wParam) == IDM_OPCJE)
        // Wywietl okno dialogowe
        if(DialogBox(zadanie, "DIALOG_1", okno, 
           (DLGPROC)ProcDialogu))
        {   
          // Poka lub schowaj paski przewijania
          ShowScrollBar(okno, SB_HORZ, poziomy);
          ShowScrollBar(okno, SB_VERT, pionowy);
          // Zmie tytu okna
          SetWindowText(okno, tytul);
          // Zmie wielko okna
          switch(wielkosc)
          {
            case 0:
              SetWindowPos(okno, HWND_TOP, 0, 0, 
                           200, 150, SWP_NOMOVE);
              break;
            case 1:
              SetWindowPos(okno, HWND_TOP, 0, 0, 
                           400, 300, SWP_NOMOVE);
              break;
            case 2:
              SetWindowPos(okno, HWND_TOP, 0, 0, 
                           600, 400, SWP_NOMOVE);
          }
          // Odmaluj to okna 
          InvalidateRect(okno, NULL, TRUE);
        }
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Procedura dialogu gwnego
BOOL CALLBACK ProcDialogu(HWND dialog, UINT komunikat,
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
    {
      // Zapamitaj uchwyt zakadki w zmiennej hTab
      hTab = GetDlgItem(dialog, ID_TAB);

      // Wstaw dwie zakadki "Kolor" oraz "Styl okna"
      TC_ITEM tc;
      tc.mask = TCIF_TEXT;
      tc.pszText = "Kolor";
      SendDlgItemMessage(dialog, ID_TAB, TCM_INSERTITEM, 
                         0, (LPARAM)&tc);
      tc.pszText = "Styl okna";
      SendDlgItemMessage(dialog, ID_TAB, TCM_INSERTITEM, 
                         1, (LPARAM)&tc);

      /* Twrz okna dialogowe wywietlane w zakadkach */
      hDialog1 = CreateDialog(zadanie, "DIALOG_2", hTab, 
                             (DLGPROC)ProcDialogu1);
      hDialog2 = CreateDialog(zadanie, "DIALOG_3", hTab, 
                             (DLGPROC)ProcDialogu2);

      // Pocztkowo wybrana jest zakadka o indeksie 0
      zakladka = 0;
      hDialog = hDialog1;
      ShowWindow(hDialog, SW_SHOW);
      return TRUE;
    }
    case WM_NOTIFY:
      // Uytkownik wybra now zakadk
      if(((LPNMHDR)lParam)->code == TCN_SELCHANGE)
      {
        // Schowaj okno dialogowe poprzedniej zakadki
        ShowWindow(hDialog, SW_HIDE);

        // Odczytaj indeks nowo wybranej zakadki
        zakladka = TabCtrl_GetCurSel(hTab);
        // i wywietl zwizane z ni okno dialogowe
        switch(zakladka)
        {
          case 0:
            hDialog = hDialog1;
            break;
          case 1:
            hDialog = hDialog2;
            break;
        }
        ShowWindow(hDialog, SW_SHOW);
      }
      return TRUE;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case ID_OK: // Nacinito przycisk OK

          /* Odczytaj dokonane przez uytkownika wybory 
             w obu oknach dialogowych */
          Odczytaj1(hDialog1);
          Odczytaj2(hDialog2);
          // Zniszcz niemodalne okna dialogowe
          DestroyWindow(hDialog1);
          DestroyWindow(hDialog2);
          hDialog = NULL;
          // Zamknij okno dialogowe zwracajc TRUE
          EndDialog(dialog, TRUE);
          return TRUE;
        case ID_ANULUJ:
          // Zniszcz niemodalne okna dialogowe
          DestroyWindow(hDialog1);
          DestroyWindow(hDialog2);
          EndDialog(dialog, FALSE);
          // Zamknij okno dialogowe zwracajc FALSE
          return TRUE;
      }
      return FALSE;
    case WM_CLOSE:
      DestroyWindow(hDialog1);
      DestroyWindow(hDialog2);
      EndDialog(dialog, FALSE);
      return TRUE;
  }
  return FALSE;
}

// Procedura dialogu pierwszej zakadki "Kolor"
BOOL CALLBACK ProcDialogu1(HWND dialog, UINT komunikat,
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
      // Ustaw zakres paska przesuwnego na 0-25
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETRANGE, TRUE, MAKELONG(0,25));
      /* Ustaw pozycj suwaka zalenie 
         od aktualnej jasnoci */
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETPOS, (WPARAM)TRUE, jasnosc);
      /* Zaznacz przycisk radiobutton odpowiadajcy
         aktualnie wybranemu kolorowi */
      switch(kolor)
      {
        case 0: 
          CheckDlgButton(dialog, ID_CZERWONY, BST_CHECKED);
          break;
        case 1: 
          CheckDlgButton(dialog, ID_ZIELONY, BST_CHECKED);
          break;
        case 2: 
          CheckDlgButton(dialog,ID_NIEBIESKI, BST_CHECKED);
          break;
      }
      return TRUE;
  }
  return FALSE;
}

// Procedura dialogu drugiej zakadki "Styl okna"
BOOL CALLBACK ProcDialogu2(HWND dialog, UINT komunikat,
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
      /* Zaznacz przycisk radiobutton odpowiadajcy
         wybranej wielkoci okna*/
      switch(wielkosc)
      {
        case 0: 
          CheckDlgButton(dialog, ID_MALE, BST_CHECKED);
          break;
        case 1: 
          CheckDlgButton(dialog, ID_SREDNIE, BST_CHECKED);
          break;
        case 2: 
          CheckDlgButton(dialog, ID_DUZE, BST_CHECKED);
          break;
      }
      // Wpisz tytu do okienka Edit
      SetDlgItemText(dialog, ID_TYTUL, tytul);
      // Ustaw checkbox'y odpowiadajce paskom przewijania
      if(pionowy)
        CheckDlgButton(dialog, ID_PIONOWYPP, BST_CHECKED);
      if(poziomy)
        CheckDlgButton(dialog, ID_POZIOMYPP, BST_CHECKED);
      return TRUE;
  }
  return FALSE;
}

/* Odczytaj parametry ustawione przez 
   uytkownika w zakadce "Kolor" */
void Odczytaj1(HWND dialog)
{
  /* Odczytaj, ktry przycisk koloru
     jest wybrany */
  if(IsDlgButtonChecked(dialog,ID_CZERWONY))
    kolor = 0;
  else if(IsDlgButtonChecked(dialog,ID_ZIELONY))
    kolor = 1;
  else if(IsDlgButtonChecked(dialog,ID_NIEBIESKI))
    kolor = 2;
  // Odczytaj jasno koloru 
    jasnosc = SendDlgItemMessage(dialog, ID_JASNOSC, 
                                  TBM_GETPOS, 0, 0);
}

/* Odczytaj parametry ustawione przez 
   uytkownika w zakadce "Stan okna" */
void Odczytaj2(HWND dialog)
{
  // Odczytaj, jaka wielko okna jest wybrana
  if(IsDlgButtonChecked(dialog,ID_MALE))
    wielkosc = 0;
  else if(IsDlgButtonChecked(dialog,ID_SREDNIE))
    wielkosc = 1;
  else if(IsDlgButtonChecked(dialog,ID_DUZE))
    wielkosc = 2;
  // Przeczytaj tytu z okienka Edit
  GetDlgItemText(dialog, ID_TYTUL, tytul, 80);
  // Odczytaj stan checkbox'w paskw przewijania
  pionowy = IsDlgButtonChecked(dialog, ID_PIONOWYPP);
  poziomy = IsDlgButtonChecked(dialog, ID_POZIOMYPP);
}
