#include <windows.h>
#include <commctrl.h>
#include "Arkusz.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu1(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ProcDialogu2(HWND, UINT, WPARAM, LPARAM);

// Uchwyt okna gwnego aplikacji
HWND Okno;

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Zmienne przechowujce wybrany kolor i jasno,
int kolor=0, jasnosc=10;
// tytu okna,
char tytul[80];
// jego wielko,
int wielkosc = 1;
// oraz informacje o obecnoci paskw przewijania
BOOL pionowy = TRUE, poziomy = TRUE;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  InitCommonControls();

  strcpy(tytul, "Mj program");
  Okno = CreateWindowEx(0,nazwaKlasy, tytul, 
                WS_OVERLAPPEDWINDOW 
                | WS_HSCROLL | WS_VSCROLL,
                100, 50, 400, 300,
                NULL, NULL, zad, NULL);

  ShowWindow(Okno, trybOkna);
  UpdateWindow(Okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      // Oblicz warto koloru
      int kol = (jasnosc*10)<<(kolor*8);
      // Twrz pdzel o zadanym kolorze
      HBRUSH pedzel = CreateSolidBrush(kol);
      // Wypenij to okna stworzonym pdzlem
      FillRect(kont, &ps.rcPaint, pedzel);
      DeleteObject(pedzel);
      EndPaint(okno, &ps);
      return 0;
    }
    case WM_COMMAND:
      // Wybrano polecenie Opcje z menu
      if(LOWORD(wParam) == IDM_OPCJE)
      // Wywietl arkusz waciwoci
      {
        // Stwrz dwie strony dla arkusza waciwoci
        HPROPSHEETPAGE strony[2];

        PROPSHEETPAGE psp;
        psp.dwSize = sizeof(PROPSHEETPAGE);
        psp.dwFlags = 0;
        psp.hInstance = zadanie;
        psp.pszTemplate = "STRONA_1";
        psp.pfnDlgProc = (DLGPROC)ProcDialogu1;
        strony[0] = CreatePropertySheetPage(&psp);

        psp.dwSize = sizeof(PROPSHEETPAGE);
        psp.dwFlags = 0;
        psp.hInstance = zadanie;
        psp.pszTemplate = "STRONA_2";
        psp.pfnDlgProc = (DLGPROC)ProcDialogu2;
        strony[1] = CreatePropertySheetPage(&psp);

        // Wywietl arkusz waciwoci
        PROPSHEETHEADER psh;
        psh.dwSize = sizeof(PROPSHEETHEADER);
        psh.dwFlags = 0;
        psh.hwndParent = okno;
        psh.hInstance = zadanie;
        psh.pszCaption = "Arkusz waciwoci";
        psh.nPages = 2;
        psh.nStartPage = 0;
        psh.phpage = strony;
        PropertySheet(&psh);
      }
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Procedura dialogu pierwszej strony "Kolor"
BOOL CALLBACK ProcDialogu1(HWND dialog, UINT komunikat,
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_NOTIFY:
      // Nacinito przycisk OK lub Zastosuj
      if(((LPNMHDR)lParam)->code == PSN_APPLY)
      {
        /* Odczytaj, ktry przycisk koloru jest wybrany */
        if(IsDlgButtonChecked(dialog,ID_CZERWONY))
          kolor = 0;
        else if(IsDlgButtonChecked(dialog,ID_ZIELONY))
          kolor = 1;
        else if(IsDlgButtonChecked(dialog,ID_NIEBIESKI))
          kolor = 2;
        // Odczytaj jasno koloru 
          jasnosc = SendDlgItemMessage(dialog, ID_JASNOSC, 
                                TBM_GETPOS, 0, 0);
        // Odmaluj to okna 
        InvalidateRect(Okno, NULL, TRUE);
      }
      return TRUE;
    /* Jeeli uytkownik zmieni co na stronie 
       to wcz przycisk Zastosuj */
    case WM_COMMAND:
      if(HIWORD(wParam) != BN_CLICKED) return FALSE;
    case WM_HSCROLL:
      PropSheet_Changed(GetParent(dialog), dialog);
      return TRUE;
    case WM_INITDIALOG:
      // Ustaw zakres paska przesuwnego na 0-25
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETRANGE, TRUE, MAKELONG(0,25));
      /* Ustaw pozycj suwaka zalenie 
         od aktualnej jasnoci */
      SendDlgItemMessage(dialog, ID_JASNOSC, 
          TBM_SETPOS, (WPARAM)TRUE, jasnosc);
      /* Zaznacz przycisk radiobutton odpowiadajcy
         aktualnie wybranemu kolorowi */
      switch(kolor)
      {
        case 0: 
          CheckDlgButton(dialog, ID_CZERWONY, BST_CHECKED);
          break;
        case 1: 
          CheckDlgButton(dialog, ID_ZIELONY, BST_CHECKED);
          break;
        case 2: 
          CheckDlgButton(dialog,ID_NIEBIESKI, BST_CHECKED);
          break;
      }
      return TRUE;
  }
  return FALSE;
}

// Procedura dialogu drugiej strony "Styl okna"
BOOL CALLBACK ProcDialogu2(HWND dialog, UINT komunikat,
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_NOTIFY:
      // Nacinito przycisk OK lub Zastosuj
      if(((LPNMHDR)lParam)->code == PSN_APPLY)
      {
        // Odczytaj, jaka wielko okna jest wybrana
        if(IsDlgButtonChecked(dialog,ID_MALE))
          wielkosc = 0;
        else if(IsDlgButtonChecked(dialog,ID_SREDNIE))
          wielkosc = 1;
        else if(IsDlgButtonChecked(dialog,ID_DUZE))
          wielkosc = 2;
        // Przeczytaj tytu z okienka Edit
        GetDlgItemText(dialog, ID_TYTUL, tytul, 80);
        // Odczytaj stan checkbox'w paskw przewijania
        pionowy = IsDlgButtonChecked(dialog, ID_PIONOWYPP);
        poziomy = IsDlgButtonChecked(dialog, ID_POZIOMYPP);          

        // Poka lub schowaj paski przewijania
        ShowScrollBar(Okno, SB_HORZ, poziomy);
        ShowScrollBar(Okno, SB_VERT, pionowy);
        // Zmie tytu okna
        SetWindowText(Okno, tytul);
        // Zmie wielko okna
        SetWindowPos(Okno, HWND_TOP, 0, 0, 
                     200 + wielkosc * 200,
                     200 + wielkosc * 100, 
                     SWP_NOMOVE);
      }
      return TRUE;
    /* Jeeli uytkownik zmieni co na stronie 
       to wcz przycisk Zastosuj */
    case WM_COMMAND:
      if(HIWORD(wParam) == EN_CHANGE 
        || HIWORD(wParam) == BN_CLICKED)
        PropSheet_Changed(GetParent(dialog), dialog);
      return TRUE;
    case WM_INITDIALOG:
      /* Zaznacz przycisk radiobutton odpowiadajcy
         wybranej wielkoci okna*/
      switch(wielkosc)
      {
        case 0: 
          CheckDlgButton(dialog, ID_MALE, BST_CHECKED);
          break;
        case 1: 
          CheckDlgButton(dialog, ID_SREDNIE, BST_CHECKED);
          break;
        case 2: 
          CheckDlgButton(dialog, ID_DUZE, BST_CHECKED);
          break;
      }
      // Wpisz tytu do okienka Edit
      SetDlgItemText(dialog, ID_TYTUL, tytul);
      // Ustaw checkbox'y odpowiadajce paskom przewijania
      if(pionowy)
        CheckDlgButton(dialog, ID_PIONOWYPP, BST_CHECKED);
      if(poziomy)
        CheckDlgButton(dialog, ID_POZIOMYPP, BST_CHECKED);
      return TRUE;
  }
  return FALSE;
}
