#include <stdlib.h>
#include <windows.h>
#include <commctrl.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
HWND hUpDown, hEdit;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = CS_HREDRAW | CS_VREDRAW;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  //Inicjalizuj obsug wsplnych obiektw sterujcych
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "UpDown", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Twrz tekstowe okno bliniacze dla obiektu UpDown
      hEdit = CreateWindowEx(WS_EX_CLIENTEDGE,"EDIT","0",
        WS_CHILD | WS_VISIBLE | ES_NUMBER, 100,100,70,32,
        okno, NULL, zadanie, NULL);
      // Twrz obiekt UpDown
      hUpDown = CreateUpDownControl(WS_CHILD | WS_VISIBLE
        | UDS_SETBUDDYINT | UDS_ALIGNRIGHT, 0, 0, 0, 0,
        okno, 100, zadanie, hEdit, 99, 0, 0);
      return 0;
    }
    case WM_DESTROY:
      char bufor[5];
      // Odczytaj i wywietl tekst z okna Edit
      SendMessage(hEdit, WM_GETTEXT, 5, (LPARAM)bufor);
      MessageBox(okno, bufor, "Okno Edit", MB_OK);
      /* Odczytaj, konwertuj na tekst i wywietl 
         warto z obiektu UpDown */
      itoa(SendMessage(hUpDown, UDM_GETPOS, 0, 0),
           bufor, 10); 
      MessageBox(okno, bufor, "Obiekt UpDown", MB_OK);
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
