#include <windows.h>
#include <commctrl.h>
#include <stdio.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
HWND hTrackbar, hTekst;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = 
       (HBRUSH)GetStockObject(LTGRAY_BRUSH);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  //Inicjalizuj obsug wsplnych obiektw sterujcych
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Trackbar", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Twrz pasek przesuwny      
      hTrackbar = CreateWindowEx(0,TRACKBAR_CLASS, "",
        WS_CHILD | WS_BORDER | WS_VISIBLE | TBS_AUTOTICKS,
        40, 100, 300, 40, okno, NULL, zadanie, NULL);
      // Ustaw zakres 0-20
      SendMessage(hTrackbar, TBM_SETRANGE, 
                  0, MAKELONG(0, 20));
      /* Twrz obiekt klasy STATIC wykorzystywany
         do wywietlania tekstu */
      hTekst = CreateWindow("STATIC", 
                  "Pooenie suwaka: 0", 
                  WS_CHILD | WS_VISIBLE | SS_CENTER,
                  40, 40, 300, 30,
                  okno, NULL, zadanie, NULL);
      return 0;
    }
    case WM_HSCROLL:
    {
      char bufor[30];
      // Odczytaj pozycj suwaka
      int poz = SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
      // Sformatuj wywietlany tekst
      sprintf(bufor, "Pooenie suwaka: %d",poz);
      // Wywietl tekst
      SendMessage(hTekst, WM_SETTEXT, 0, (LPARAM)bufor);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
