#include <windows.h>
#include <commctrl.h>
#include <stdlib.h>
#include <string.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
void TworzStatusbar(HWND);

HWND hOknoStatusu;

HINSTANCE zadanie;
char nazwaKlasy[] = "nazwa1";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int TrybOkna)
{
  WNDCLASS klasaOkna;
  
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION); 
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL; 
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = GetStockObject(WHITE_BRUSH);
  
  if(!RegisterClass(&klasaOkna)) return 0;

  HWND okno = CreateWindow(nazwaKlasy, "Mj program", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);
  zadanie = zad; 

  //Inicjalizuj obsug wsplnych obiektw sterujcych
  InitCommonControls(); 

  ShowWindow(okno, TrybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  char bufor[15];
  switch(komunikat)
  {
    case WM_CREATE:
      TworzStatusbar(okno); /* Twrz pasek stanu */
      return 0;
    case WM_MOUSEMOVE:
      /* zamie wsprzdn x kursora myszki 
         na tekst i umie w buforze */
      itoa(LOWORD(lParam),bufor,10); 
      strcat(bufor,", ");
        /* dopisz wsprzdn y do bufora */
      itoa(HIWORD(lParam),bufor+strlen(bufor),10);
        /* wypisz wsprzdne w pasku stanu */
      SendMessage(hOknoStatusu, SB_SETTEXT, (WPARAM)0,          			
                  (LPARAM)bufor);
      return 0;
    case WM_LBUTTONDOWN: 
      /* wypisz odpowiedni tekst w pasku stanu */
      SendMessage(hOknoStatusu, SB_SETTEXT, (WPARAM)1, 
              (LPARAM)"Nacinity lewy przycisk myszki");
      return 0;
    case WM_LBUTTONUP: /* wypisz odpowiedni tekst 
                          w pasku stanu */
      SendMessage(hOknoStatusu, SB_SETTEXT, (WPARAM)1, 
               (LPARAM)"Zwolniony lewy przycisk myszki");
      return 0;
    case WM_SIZE:
      /* Wylij do pasku stanu komunikat WM_SIZE 
         informujcy o zmianie wielkoci okna */ 
      SendMessage(hOknoStatusu, WM_SIZE, wParam, lParam);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

void TworzStatusbar(HWND okno)
{
  /* szeroko czci pasku statusu */
  int czesci[2]={100,400};
  /* Twrz okno statusu */
  hOknoStatusu = CreateStatusWindow( WS_CHILD | WS_VISIBLE,				
                                     "0, 0", okno, 100);
  /* Podziel okno statusu na dwie czci */
  SendMessage( hOknoStatusu, SB_SETPARTS, (WPARAM)2, 			   
               (LPARAM)czesci);
}
