#include <windows.h>
#include <commctrl.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;
HWND hProgress;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = CS_HREDRAW | CS_VREDRAW;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground =
    (HBRUSH)GetStockObject(WHITE_BRUSH);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  //Inicjalizuj obsug wsplnych obiektw sterujcych
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Progress", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Twrz wskanik zaawansowania
      hProgress = CreateWindowEx(WS_EX_CLIENTEDGE,
                                 PROGRESS_CLASS, "",
                                 WS_CHILD | WS_VISIBLE,
                                 0, 0, 0, 0, 
                                 okno, NULL, zadanie, NULL);
      /* Ustaw krok wskanika
        (zakres wynosi domylnie od 0 do 100) */
      SendMessage(hProgress, PBM_SETSTEP, 2, 0);
      return 0;
    }
    case WM_SIZE:
      // Umie wskanik zaawansowania w dolnej czci okna
      MoveWindow(hProgress, 0, HIWORD(lParam) - 20, 
                 LOWORD(lParam), 20, TRUE);
      return 0;
    case WM_PAINT:
    {
      RECT prost;
      PAINTSTRUCT ps;
      HDC kont = BeginPaint(okno, &ps);
      GetClientRect(okno, &prost);
      /* Wsprzdne prostokta opisujcego elips,
         oraz wartoci krokw, o jakie bdzie si on 
         zmniejsza dla kolejnej elipsy */
      int x,y,krokx,kroky;
      krokx = prost.right / 100;
      kroky = (prost.bottom - 20) / 100;
      x = 0; 
      y = 0;
      // Umie w kontekcie urzdzenia przeroczyste piro
      HPEN pioro = GetStockObject(NULL_PEN);
      pioro = SelectObject(kont, pioro);
      // Odczytaj domylny pdzel z kontekstu
      HBRUSH pedzel = GetStockObject(WHITE_BRUSH);
      HBRUSH domyslnyPedzel = SelectObject(kont, pedzel);
      /* Rysuj pidziesit elips, z ktrych kada
         jest mniejsza od poprzedniej */
      for(int i=0; i<50; i++)
      {
        /* Stwrz pdzel o janiejszym kolorze 
           dla kadej kolejnej elipsy */
        pedzel = CreateSolidBrush(RGB(50 + i*4, 0, 50 + i*2));
        SelectObject(kont, pedzel);
        Ellipse(kont, x, y, prost.right - x, 
                prost.bottom - 20 - y);
        DeleteObject(pedzel);
        // Sygnalizuj postp na wskaniku zaawansowania 
        SendMessage(hProgress, PBM_STEPIT, 0, 0);
        /* Modyfikuj wsprzdne prostokta opisujcego elips */
        x += krokx;
        y += kroky;
      }
      // Przywr do kontekstu domylne piro i pdzel
      SelectObject(kont, domyslnyPedzel);
      SelectObject(kont, pioro);
      EndPaint(okno, &ps);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
