#include <windows.h>
#include <commctrl.h>
#include <string.h>
#include <stdio.h>
#include "listview.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

/* Procedura porwnujca dwie etykiety, 
   uywana przy sortowaniu listy-widoku */
int CALLBACK Porownaj(LPARAM, LPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// uchwyt listy-widoku
HWND hListView;

// Zmienna przechowujca uchwyt menu okna programu
HMENU hMenu;
// Zmienna pamitajca, ktra pozycja menu jest zaznaczona
WORD poprz = ID_RAP;

// Lista obrazw przechowujca mae ikony
HIMAGELIST hMIkony;
// Lista obrazw przechowujca due ikony
HIMAGELIST hDIkony;

// Teksty umieszczane w etykietach
char *imie[6] = {"Ania","Janusz","Marta",
                 "Agnieszka","Darek","Marek"};
char *wiek[6] = {"24","25","23","24","96","18"};
char *telefon[6] = {"213-453","435-857","112-223",
                    "947-123","234-946","121-319"};
      
int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "menu1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  // Zapamitaj uchwyt zadania
  zadanie = zad;
  
  // Inicjalizuj wykorzystanie wsplnych obiektw
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, "List View", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  hMenu = GetMenu(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  int i;
  HICON ik1, ik2, ik3;
  switch(komunikat)
  {
    case WM_CREATE:
      // Zaaduj trzy systemowe ikony 
      ik1 = LoadIcon(NULL, IDI_WINLOGO);
      ik2 = LoadIcon(NULL, IDI_EXCLAMATION);
      ik3 = LoadIcon(NULL, IDI_HAND);

      // Twrz list zawierajc due ikony
      hDIkony = ImageList_Create(32, 32, ILC_COLOR, 1, 0);
      ImageList_SetBkColor(hDIkony, RGB(255,255,255));
      ImageList_AddIcon(hDIkony, ik1);
      ImageList_AddIcon(hDIkony, ik2);
      ImageList_AddIcon(hDIkony, ik3);

      // Twrz list zawierajc mae ikony
      hMIkony = ImageList_Create(16, 16, ILC_COLOR, 1, 0);
      ImageList_SetBkColor(hMIkony, RGB(255,255,255));
      ImageList_AddIcon(hMIkony, ik1);
      ImageList_AddIcon(hMIkony, ik2);
      ImageList_AddIcon(hMIkony, ik3);

      // Twrz list-widok
      hListView = CreateWindowEx(WS_EX_CLIENTEDGE, 
                    WC_LISTVIEW, NULL, 
                    WS_CHILD | WS_VISIBLE | LVS_REPORT, 
                    0, 0, 10, 10, 
                    okno, NULL, zadanie, NULL);

      // Przypisz listy obrazw do listy-widoku
      ListView_SetImageList(hListView, hDIkony, LVSIL_NORMAL);
      ListView_SetImageList(hListView, hMIkony, LVSIL_SMALL);
      
      /* Wstaw do raportu trzy kolumny podajc ich
         sposb wyrwnania, szeroko oraz tekst */
      LV_COLUMN lvc;
      lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT;
      lvc.fmt = LVCFMT_LEFT; 
      lvc.cx = 100; 
      lvc.pszText = "Imi";
      ListView_InsertColumn(hListView, 0, &lvc);
      lvc.pszText = "Wiek";
      ListView_InsertColumn(hListView, 1, &lvc);
      lvc.pszText = "Telefon";
      ListView_InsertColumn(hListView, 2, &lvc);
      
      // Wstaw do listy-widoku sze etykiet
      LV_ITEM lvi;
      lvi.mask = LVIF_IMAGE | LVIF_TEXT | LVIF_PARAM;
      lvi.iSubItem = 0;
      for(i = 0; i < 6; i++)
      {
        // Indeks ikony z przedziau 0-2
        lvi.iImage = i % 3;
        // Kolejny numer etykiety
        lvi.iItem = i;
        // Parametr wykorzystywany przy sortowaniu
        lvi.lParam = i;
        // Tekst wstawianej etykiety
        lvi.pszText = imie[i];
        // Wstaw etykiet do listy-widoku
        ListView_InsertItem(hListView, &lvi);
        /* Wstaw  dla kadej etykiety tekst 
           do dodatkowych kolumn raportu */
        ListView_SetItemText(hListView, i, 1, wiek[i]);
        ListView_SetItemText(hListView, i, 2, telefon[i]);
      }
      return 0;
    case WM_NOTIFY:
      // Czy kliknito na nagwku kolumny?
      if(((LPNMHDR)lParam)->code == LVN_COLUMNCLICK)
      {
        // Sortuj etykiety wg wybranej kolumny
        ListView_SortItems(hListView, Porownaj, 
          ((NM_LISTVIEW *)lParam)->iSubItem );
      }
      return 0;
    case WM_SIZE:
      // Zmie wymiary listy-widoku
      MoveWindow(hListView, 10, 10, LOWORD(lParam)-20,
                 HIWORD(lParam)-20, TRUE);  
      return 0;
    case WM_COMMAND:
      // Odznacz poprzednio zaznaczon pozycj menu
      CheckMenuItem(hMenu, poprz, MF_UNCHECKED);
      
      // Zapamitaj i zaznacz now pozycj w menu
      poprz = LOWORD(wParam); 
      CheckMenuItem(hMenu, poprz, MF_CHECKED);

      // Ustal nowy sposb wywietlania listy-widoku
      switch(LOWORD(wParam))
      { 
        case ID_DIK:  // Due ikony
          SetWindowLong(hListView,GWL_STYLE,
            WS_CHILD | WS_VISIBLE | LVS_ICON);
          break;
        case ID_MIK:  // Mae ikony
          SetWindowLong(hListView,GWL_STYLE,
            WS_CHILD | WS_VISIBLE | LVS_SMALLICON);
          break;
        case ID_LST:  // Lista
          SetWindowLong(hListView,GWL_STYLE,
            WS_CHILD | WS_VISIBLE | LVS_LIST);
          break;
        case ID_RAP:  // Raport
          SetWindowLong(hListView,GWL_STYLE,
            WS_CHILD | WS_VISIBLE | LVS_REPORT);
          break;
      }
      // Wyrwnaj etykiety do grnego brzegu obiektu
      ListView_Arrange(hListView, LVA_ALIGNTOP);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

int CALLBACK Porownaj(LPARAM lParam1, LPARAM lParam2, 
			              LPARAM lParamSort)
{
  // Porwnaj dwie etykiety na podstawie zadanej kolumny
  switch(lParamSort)
  {
    case 0: // wg imion
      return stricmp(imie[lParam1],imie[lParam2]);
    case 1: // wg wieku
      return stricmp(wiek[lParam1],wiek[lParam2]);
    case 2: // wg telefonu
      return stricmp(telefon[lParam1],telefon[lParam2]);
  }
  return 0;
}
