#include <windows.h>
#include "rmenu.h"

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HMENU hMenu;      // Uchwyt podmenu
HBRUSH pedzel[3]; // Tablica pdzli 
int kolor;        // Biecy kolor powierzchni okna

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, LPSTR, 
                   int trybOkna)
{
  WNDCLASS klasaOkna;
  /* Wypenij struktur suc do zarejestrowania klasy 
     okna w systemie */
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = NULL;
  // Rejestruj okno w systemie
  if(!RegisterClass(&klasaOkna)) return 0;

  HWND okno = CreateWindowEx(0,nazwaKlasy, "Pynne menu", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  // Wywietl okno
  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);
  // aduj podmenu
  hMenu=GetSubMenu(LoadMenu(zad,"menu1"),0);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
      // stwrz pdzle do wypeniania okna
      pedzel[0] = CreateSolidBrush(RGB(150,0,0));
      pedzel[1] = CreateSolidBrush(RGB(0,150,0));
      pedzel[2] = CreateSolidBrush(RGB(0,0,150));
      kolor = 0;
      return 0;
    case WM_PAINT:
    {
      PAINTSTRUCT paint;
      RECT prost;
      HDC kont = BeginPaint(okno, &paint);;
      // Pobierz rozmiar okna
      GetClientRect(okno, &prost);
      // Wypenij cae okno zadanym kolorem
      FillRect(kont, &prost, pedzel[kolor]);
      EndPaint(okno, &paint);
      return 0;
    }
    case WM_RBUTTONDOWN:
    {  
      POINT punkt;
      punkt.x = LOWORD(lParam);
      punkt.y = HIWORD(lParam);
      // Przelicz wsprzdne kursora myszki
      ClientToScreen(okno, &punkt);
      // Wywietl menu
      TrackPopupMenu(hMenu, TPM_CENTERALIGN | 
                     TPM_RIGHTBUTTON, punkt.x, 
                     punkt.y, 0, okno, NULL);
      return 0;
    }
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDM_CZERWONY:  kolor = 0; break;
        case IDM_ZIELONY:   kolor = 1; break;
        case IDM_NIEBIESKI: kolor = 2; break;
        default: return 0;          
      }
      /* Uniewanij powierzchni okna wymuszajc jej 
         odmalowanie */
      InvalidateRect(okno, NULL, TRUE); 
      break;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      break;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
  return 0;
} 

