#include <windows.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
    LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;
  HWND okno = CreateWindowEx(0, nazwaKlasy, 
                "Moja Aplikacja", 
                WS_OVERLAPPED | WS_CAPTION | 
                WS_SYSMENU | WS_THICKFRAME,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_NCPAINT:
    {
      /* Przeka obsug komunikatu WM_NCPAINT do systemu,
         aby narysowane zostay ramki okna */
      DefWindowProc(okno, komunikat, wParam, lParam);
      // Pobierz kontekst caego okna
      HDC kont = GetWindowDC(okno);
      // Oblicz szeroko okna
      RECT prost;
      GetWindowRect(okno, &prost);
      int szerOkna = prost.right - prost.left;
      /* Pobierz wymiary ramki, paska tytuowego
         oraz przycisku */
      int szerRamki = GetSystemMetrics(SM_CYFIXEDFRAME);
      int wysRamki = GetSystemMetrics(SM_CXFIXEDFRAME);
      int wysPaska = GetSystemMetrics(SM_CYCAPTION);
      int szerPrzycisku = GetSystemMetrics(SM_CXSIZE);
      // Oblicz szeroko paska tytuowego
      int szer = szerOkna - 2*szerRamki - szerPrzycisku;
      
      int kolor = 0;
      int krok = 250 / (szer / 4);
      
      prost.top = wysRamki + 1;
      prost.bottom = wysRamki + wysPaska;
      
      for(int x=szerRamki; x<szer; x+=4)
      {
        // twrz pdzel o coraz janiejszym kolorze
        kolor += krok;
        HBRUSH pedzel = 
        CreateSolidBrush(RGB(kolor,0,kolor));
        // Wypenij kolejny kawaek paska
        prost.left = x;
        prost.right = x + 4;
        FillRect(kont, &prost, pedzel);
        DeleteObject(pedzel);
      }
      // Wywietl tytu okna w pasku tytuowym
      SetBkMode(kont, TRANSPARENT);
      SetTextColor(kont, RGB(255,255,0));
      TextOut(kont, szerRamki+2, wysRamki+2, 
              "Moja Aplikacja", 14);
      ReleaseDC(okno, kont);
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
