#include <windows.h>
#include <commdlg.h>
#include <commctrl.h>
#include <mmsystem.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL Otworz(HWND, char *, int, char *);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Flaga okrelajca czy jest otwarty plik dwikowy
BOOL otwarty = FALSE;

// Uchwyty przyciskw oraz paska przesuwnego
HWND hPlay, hStop, hTrackbar;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  // Inicjalizuj uycie wsplnych obiektw sterujcych 
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, 
                "Odtwarzacz plikw dwikowych", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                400, 80,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  char bufor[128];
  switch(komunikat)
  {
    case WM_CREATE:
      // Sprawd, czy mona odtwarza pliki dwikowe
      if(midiOutGetNumDevs()==0)
        MessageBox(okno,"Brak dostpnego urzdzenia\n do odtwarzania plikw midi",
                   "Uwaga", MB_OK);
      if(waveOutGetNumDevs()==0)
        MessageBox(okno,"Brak dostpnego urzdzenia\n do odtwarzania plikw wave",
                   "Uwaga", MB_OK);

      /* Stwrz dwa przyciski Play i Stop, 
         oraz pasek przesuwny obrazujcy 
         biec pozycj odtwarzanego pliku */
      RECT prost;
      GetClientRect(okno, &prost);
      hPlay = CreateWindow("BUTTON", "Play", 
        WS_CHILD | WS_VISIBLE, 0,0,80,prost.bottom, 
        okno, (LPVOID)101, zadanie, NULL);
      hStop = CreateWindow("BUTTON", "Stop", 
        WS_CHILD | WS_VISIBLE, 80,0,80,prost.bottom, 
        okno, (LPVOID)102, zadanie, NULL);
      hTrackbar = CreateWindow(TRACKBAR_CLASS, "",
        WS_CHILD | WS_BORDER | WS_VISIBLE | TBS_AUTOTICKS,
        160, 0, prost.right-160, prost.bottom, 
        okno, NULL, zadanie, NULL);
      
      return 0;
    case WM_TIMER:
      if(otwarty)
      {
        // Pobierz biec pozycj odgrywanego pliku
        mciSendString("status 1 position", bufor, 128, NULL);
        // i przesu odpowiednio suwak paska
        SendMessage(hTrackbar, TBM_SETPOS, (WPARAM)TRUE, 
                    atoi(bufor)/1000);
      }
      return 0;
    case WM_HSCROLL:
    {
      // Uytkownik przesun suwak paska przesuwnego
      if(otwarty)
      {
        int p = SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
        // Ustaw now pozycj odtwarzanego pliku
        wsprintf(bufor, "seek 1 to %d", p*1000);
        mciSendString(bufor, NULL, 0, NULL);
      }
      return 0;
    }
    case MM_MCINOTIFY:
      // Odtwarzanie pliku zostao zakoczone
      // Wycz uyty zegar
      KillTimer(okno,1);
      // Ustaw biec pozycj na pocztek pliku 
      mciSendString("seek 1 to start", NULL, 0, NULL);
      return 0;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        // Uytkownik wybra z menu polecenie Otwrz
        case 100:
        {
          char plik[256];
          if (Otworz(okno, plik, 256, "Pliki MIDI\0*.mid\0Pliki wave\0*.wav\0Wszystkie pliki\0*.*\0")
            && (stricmp(plik+strlen(plik)-4,".mid") == 0 ||
                stricmp(plik+strlen(plik)-4,".wav") == 0) )
          {
            // Zamknij poprzedni odgrywany plik dwikowy
            if(otwarty)
              mciSendString("close 1 wait", NULL, 0, NULL);
            otwarty = FALSE;
            // Otwrz plik wybrany przez uytkownika
            wsprintf(bufor,"open \"%s\" alias 1",plik);
            if(mciSendString(bufor, NULL, 0, NULL)==0)
            {
              otwarty = TRUE;
              // Zmie tytu okna
              wsprintf(bufor,"Odtwarzacz: %s",plik);
              SetWindowText(okno, bufor); 
              /* Ustaw mierzenie biecej 
                 pozycji pliku w milisekundach */
              mciSendString(
                      "set 1 time format milliseconds",
                      NULL, 0, NULL);
              /* Odczytaj dugo odtwarzanego pliku
                 ( w milisekundach) */
              mciSendString("status 1 length", 
                            bufor, 128, NULL);
              /* Ustaw zakres paska przesuwnego na rwny 
                 iloci sekund */
              SendMessage(hTrackbar, TBM_SETRANGE, TRUE, 
                          MAKELONG(0, atoi(bufor)/1000));
            }
            else
              SetWindowText(okno,
                "Odtwarzacz plikw dwikowych "); 
          }
          break;
        }
        case 101:
          // Uytkownik wcisn przycisk Play
          if(otwarty)
          {
            mciSendString("play 1 notify", NULL, 0, okno);
            /* Wcz zegar generujcy co 1/2 sekundy
               komunikaty WM_TIMER */
            SetTimer(okno,1,500,NULL);
          }
          break;
        case 102:
          // Uytkownik wcisn przycisk Stop
          if(otwarty)
          {
            mciSendString("stop 1", NULL, 0, NULL);
            // Wycz uyty zegar
            KillTimer(okno,1);
          }
          break;
      }
      return 0;
    case WM_DESTROY:
      // Zamknij odtwarzany plik
      if(otwarty)
        mciSendString("close 1 wait", NULL, 0, NULL);
      // Wycz uyty zegar
      KillTimer(okno,1);
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Funkcja wywietlajca wsplne okno dialogowe Otwrz
BOOL Otworz(HWND okno, char *plik, int rozmiar, char *filtry)
{
  OPENFILENAME ofn;
  char szDirName[256];

  // Wpisz zero do bufora na nazw pliku
  plik[0] = 0;
  // Odczytaj biecy katalog
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  
  // Wypenij zerami wszystkie pola struktury ofn
  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = okno;
  ofn.lpstrFilter = filtry;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= plik;
  ofn.nMaxFile = rozmiar;
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST 
     | OFN_FILEMUSTEXIST;

  return GetOpenFileName(&ofn); 
}
