/* Zmienna globalna przechowujca 
   uchwyt dodatkowego przycisku */
HWND przycisk;

// Funkcja filtrujca
UINT APIENTRY FunkcjaFiltr(HWND dialog, UINT komunikat, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
    {
      // Zmie tytu okna
      SetWindowText(dialog, "Wsplne okno dialogowe Czcionka");

      // Odczytaj wsprzdne ekranowe przycisku Anuluj
      RECT prost;
      HWND Anuluj = GetDlgItem(dialog,IDCANCEL);
      GetWindowRect(Anuluj, &prost);
      /* Przekszta wsprzdne ekranowe na 
         wsprzdne wzgldem obszaru klienta okna */
      POINT p1,p2;
      p1.x = prost.left; p1.y = prost.top;
      p2.x = prost.right; p2.y = prost.bottom;
      ScreenToClient(dialog, &p1);
      ScreenToClient(dialog, &p2);
      // Stwrz nowy przycisk poniej przycisku Anuluj
      przycisk = CreateWindow("BUTTON","Opcje",
        WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 
        p1.x, p2.y + 10, p2.x - p1.x, p2.y - p1.y, 
        dialog, NULL, zadanie, NULL);
      return TRUE;
    }
    case WM_COMMAND:
      if((HWND)lParam == przycisk)
      {
        // Obsuga nowego przycisku
        MessageBox(dialog, 
          "Tu powinno pojawi si okno dialogowe z opcjami",
          "Opcje", MB_OK);
        return TRUE;
      }
      else
        return FALSE;
    default:
      return FALSE;
  }
}

BOOL WybierzFont(HWND okno, LPLOGFONT font)
{
  CHOOSEFONT cf;     

  cf.lStructSize = sizeof (CHOOSEFONT);
  cf.hwndOwner = okno;
  cf.lpLogFont = font;
  cf.lpfnHook = FunkcjaFiltr;
  cf.Flags = CF_ENABLEHOOK | CF_SCREENFONTS | CF_EFFECTS;

  return ChooseFont(&cf);
}

