#include <windows.h>
#include <string.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
int CALLBACK ProceduraFontow(ENUMLOGFONT FAR*,
                    NEWTEXTMETRIC FAR*, int, LPARAM );

char nazwaKlasy[] = "nazwa1";
/* Zmienne globalne przechowujce pooenie 
   wywietlanych nazw fontw w oknie */
int y,x,maxx;
// Wysoko i szeroko okna programu
int wysOkna, szerOkna;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  /* Style CS_HREDRAW i CS_VREDRAW oznaczaj, e okno 
     bdzie odmalowywane po zmianie jego rozmiarw */
  klasaOkna.style = CS_HREDRAW | CS_VREDRAW;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  
  HWND okno = CreateWindow(nazwaKlasy, "Fonty TrueType", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_PAINT:
    {
      PAINTSTRUCT paint;
      HDC kont = BeginPaint(okno,&paint);
      // Wywietlaj od lewego grnego rogu okna
      x = y = maxx = 0;
      /* Funkcja EnumFontFamilies wywoa CzytajFonty
         dla kadego fontu w systemie */
      EnumFontFamilies(kont, NULL, 
        (FONTENUMPROC)ProceduraFontow, (LPARAM)kont);
      EndPaint(okno,&paint);
      return 0;
    }
    case WM_SIZE:
      // Zapamitaj nowe wymiary okna
      szerOkna = LOWORD(lParam);
      wysOkna = HIWORD(lParam);
      return 0;
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
     wParam, lParam);
  }
}

int CALLBACK ProceduraFontow(ENUMLOGFONT FAR* lpelf,	
  NEWTEXTMETRIC FAR* lpntm, int FontType, LPARAM kont)
{
  // Wywietlaj tylko dla fontw TrueType
  if(FontType & TRUETYPE_FONTTYPE)
  {
    SIZE s;
    // Wskanik do nazwy fontu
    char * font = lpelf->elfLogFont.lfFaceName;
    // Ustaw wysoko i szeroko fontw na domyln
    lpelf->elfLogFont.lfHeight = 0;
    lpelf->elfLogFont.lfWidth = 0;
    // Stwrz font
    HFONT hFont = 
       CreateFontIndirect(&(lpelf->elfLogFont));
    hFont = SelectObject((HDC)kont, hFont);
    // Okrel, ile miejsca zajmie tekst
    GetTextExtentPoint32((HDC)kont,font,strlen(font),&s);
    if(y + s.cy > wysOkna)
    {
      /* Jeeli tekst nie zmieci si w wierszu, 
         to przenie go do nastpnej kolumny */
      y = 0;
      x = x + maxx + 10;
      maxx = 0;
      /* Jeeli nastpna kolumna nie zmieci si w oknie,
         to zakocz wyliczanie fontw */
      if(x > szerOkna) return 0;
    }
    TextOut((HDC)kont, x, y, font, strlen(font));
    // Zapamitaj pozycj nastpnego tekstu
    y += s.cy;
    /* Zmienna maxx przechowuje szeroko kolumny,
       bdc szerokoci najszerszego tekstu */
    if(s.cx>maxx) maxx=s.cx;
     
    hFont = SelectObject((HDC)kont, hFont);
    DeleteObject(hFont);
  }
  return 1;
}
