#include <windows.h>
#include <time.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);

char nazwaKlasy[] = "nazwa1";

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
    LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(zad, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(zad, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  
  if(!RegisterClass(&klasaOkna)) return 0;

  HWND okno = CreateWindowEx(WS_EX_TOPMOST,
                nazwaKlasy, NULL, 
                WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU,
                0, 0, 0, 0, NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                           WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      // Wcz zegar generujcy komunikaty co sekund
      SetTimer(okno,1,1000,NULL);
      return 0;
    }
    case WM_TIMER:
    {
      char czas[9];
      // Umie czas systemowy w acuchu tekstowym
      _strtime(czas);  
      // Wywietl czas w belce tytuowej okna
      SetWindowText(okno,czas);
      return 0;
    }
    case WM_DESTROY:
      // Wycz zegar
      KillTimer(okno,1);
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}
