#include <windows.h>
#include <stdio.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
DWORD Watek(LPVOID);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

HWND hTekst[4];

char *teksty[4]={ "Wysoki priorytet:", 
                  "Normalny priorytet:",
                  "Niski priorytet:",
                  "Najniszy priorytet:" };

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = NULL;
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_MENU+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;
  HWND okno = CreateWindowEx(0,nazwaKlasy, "Wtki", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_CREATE:
    {
      int yTekst=10;
      DWORD id;
      int priorytet[4] = {THREAD_PRIORITY_ABOVE_NORMAL,
                          THREAD_PRIORITY_NORMAL,
                          THREAD_PRIORITY_BELOW_NORMAL,
                          THREAD_PRIORITY_LOWEST} ;

      for(int i=0; i<4; i++)
      {
        // Twrz obiekt klasy STATIC
        hTekst[i] = CreateWindow("STATIC", "", 
          WS_CHILD | WS_VISIBLE, 10, yTekst, 240, 20,
          okno, NULL, zadanie, NULL);
        // Twrz wtek
        HANDLE w = CreateThread(NULL, 0, 
                   (LPTHREAD_START_ROUTINE)Watek, 
                   (LPVOID)i, 0, &id);
        // Ustaw priorytet wtku
        SetThreadPriority(w, priorytet[i]);
        // Wsprzdna pionowa nastpnego obiektu STATIC
        yTekst += 30;
      }
      return 0;
    }
    case WM_DESTROY:
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

// Funkcja wtku
DWORD Watek(LPVOID param)
{
  int licznik =0;
  char bufor[30];
  do 
  {
    /* Konwertuj warto licznika na tekst 
       i wywietl w obiekcie STATIC */
    sprintf(bufor,"%s%d", teksty[(int)param],licznik);
    SetWindowText(hTekst[(int)param], bufor);
    // To powinno zaj troch czasu
    double k,j;
    for(int i=0;i<10000;i++)
    {
      j = i*5-3;
      k += j/2;
    }
    // Zwiksz licznik okrelajcy szybko wykonania wtku
    licznik ++;
  }
  while(TRUE);
  return 0;
}
