#include <windows.h>
#include <commctrl.h>
#include <mmsystem.h>
#include <vfw.h>

LRESULT CALLBACK ProcOkna(HWND, UINT, WPARAM, LPARAM);
BOOL Otworz(HWND, char *, int, char *);

char nazwaKlasy[] = "nazwa1";
HINSTANCE zadanie;

// Flaga okrelajca czy jest otwarty plik avi
BOOL otwarty = FALSE;

// Uchwyty przyciskw oraz paska przesuwnego
HWND hPlay, hStop, hTrackbar;

// Uchwyt okna animacji
HWND hAnim;

int WINAPI WinMain(HINSTANCE zad, HINSTANCE, 
                   LPSTR, int trybOkna)
{
  WNDCLASS klasaOkna;
  klasaOkna.style = 0;
  klasaOkna.hInstance = zad;
  klasaOkna.lpszClassName = nazwaKlasy;
  klasaOkna.lpfnWndProc = ProcOkna;
  klasaOkna.hIcon = LoadIcon(NULL, IDI_WINLOGO);
  klasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
  klasaOkna.lpszMenuName = "MENU1";
  klasaOkna.cbClsExtra = 0;
  klasaOkna.cbWndExtra = 0;
  klasaOkna.hbrBackground = (HBRUSH) (COLOR_WINDOW+1);
  if(!RegisterClass(&klasaOkna)) return 0;
  zadanie = zad;

  // Inicjalizuj uycie wsplnych obiektw sterujcych 
  InitCommonControls();

  HWND okno = CreateWindowEx(0,nazwaKlasy, 
                "Odtwarzacz plikw avi", 
                WS_OVERLAPPEDWINDOW,
                CW_USEDEFAULT, CW_USEDEFAULT,
                400, 100, NULL, NULL, zad, NULL);

  ShowWindow(okno, trybOkna);
  UpdateWindow(okno);

  MSG komunikat;
  while(GetMessage(&komunikat, NULL, 0, 0))
  {
    TranslateMessage(&komunikat);
    DispatchMessage(&komunikat);
  }
  return komunikat.wParam;
}

// Procedura obsugi komunikatw
LRESULT CALLBACK ProcOkna(HWND okno, UINT komunikat, 
                          WPARAM wParam, LPARAM lParam)
{
  char bufor[128];
  switch(komunikat)
  {
    case WM_CREATE:
      /* Stwrz dwa przyciski Play i Stop, 
         oraz pasek przesuwny obrazujcy 
         biec pozycj odtwarzanego pliku */
      RECT prost;
      GetClientRect(okno, &prost);
      hPlay = CreateWindow("BUTTON", "Play", 
        WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, 
        okno, (LPVOID)101, zadanie, NULL);
      hStop = CreateWindow("BUTTON", "Stop", 
        WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, 
        okno, (LPVOID)102, zadanie, NULL);
      hTrackbar = CreateWindow(TRACKBAR_CLASS, "",
        WS_CHILD | WS_BORDER | WS_VISIBLE,
        0, 0, 0, 0, okno, NULL, zadanie, NULL);
      return 0;
    case WM_SIZE:
    {
      // Umie przyciski oraz pasek przesuwny u dou okna
      WORD wys = HIWORD(lParam), szer = LOWORD(lParam);
      MoveWindow(hPlay, 0, wys-30, 60, 30, TRUE);
      MoveWindow(hStop, 60, wys-30, 60, 30, TRUE);
      MoveWindow(hTrackbar, 120, wys-30, szer-120, 30, TRUE);
      return 0;
    }
    case WM_TIMER:
      if(otwarty)
      {
        // Pobierz biec pozycj odgrywanego pliku
        mciSendString("status 1 position", 
                       bufor, 128, NULL);
        // i przesu odpowiednio suwak paska
        SendMessage(hTrackbar, TBM_SETPOS, (WPARAM)TRUE, 
                    atoi(bufor));
      }
      return 0;
    case WM_HSCROLL:
    {
      if(otwarty)
      {
        // Uytkownik przesun suwak paska przesuwnego
        int p = SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
        // Ustaw now pozycj odtwarzanego pliku
        wsprintf(bufor, "seek 1 to %d", p);
        mciSendString(bufor, NULL, 0, NULL);
      }
      return 0;
    }
    case MM_MCINOTIFY:
      // Odtwarzanie pliku zostao zakoczone
      // lub przerwane. Wycz uyty zegar
      KillTimer(okno,1);
      // Ustaw biec pozycj na pocztek pliku 
      mciSendString("seek 1 to start", NULL, 0, NULL);
      return 0;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        // Uytkownik wybra z menu polecenie Otwrz
        case 100:
        {
          char plik[256];
          if (Otworz(okno, plik, 256, "Pliki AVI\0*.avi\0")
            && (stricmp(plik+strlen(plik)-4,".avi") == 0) )
          {
            // Zamknij poprzedni odgrywany plik avi
            if(otwarty)
              mciSendString("close 1 wait", NULL, 0, NULL);
            otwarty = FALSE;
            // Otwrz plik wybrany przez uytkownika
            wsprintf(bufor,"open \"%s\" alias 1 \
                     style child parent %d",
                     plik, okno);
            if(mciSendString(bufor, NULL, 0, NULL)==0)
            {
              otwarty = TRUE;
              // Zmie tytu okna
              wsprintf(bufor,"Odtwarzacz: %s",plik);
              SetWindowText(okno, bufor); 
              // Poka okno animacji
              mciSendString("window 1 state show", 
                             NULL, 0, NULL);

              // Odczytaj uchwyt okna animacji
              mciSendString("status 1 window handle", 
                            bufor, 128, NULL);
              hAnim = (HWND)atoi(bufor);

              /* Dostosuj wielko obszaru klienta okna 
                 aplikacji do wielkoci okna-dziecka 
                 odtwarzajcego animacje */
              RECT prost, prost2;
            
              GetClientRect(okno, &prost);
              GetWindowRect(okno, &prost2);
              int cx = prost2.right - prost2.left 
                       - prost.right;
              int cy = prost2.bottom - prost2.top 
                       - prost.bottom;

              GetWindowRect(hAnim, &prost);
              MoveWindow(okno, prost2.left, prost2.top, 
                         cx + prost.right - prost.left, 
                         cy + prost.bottom - prost.top
                         + 30, TRUE);

              /* Ustaw mierzenie biecej 
                 pozycji pliku w ramkach */
              mciSendString("set 1 time format frames",
                            NULL, 0, NULL);
              /* Odczytaj dugo odtwarzanego pliku
                 ( w ramkach) */
              mciSendString("status 1 length", 
                            bufor, 128, NULL);
              /* Ustaw zakres paska przesuwnego na rwny 
                 iloci ramek */
              SendMessage(hTrackbar, TBM_SETRANGE, TRUE, 
 		                    MAKELONG(0, atoi(bufor)));
            }
            else
              SetWindowText(okno, "Odtwarzacz plikw avi"); 
          }
          break;
        }
        case 101:
          // Uytkownik wcisn przycisk Play
          if(otwarty)
          {
            mciSendString("play 1 notify", NULL, 0, okno);
            /* Wcz zegar generujcy co 1/10 sekundy
               komunikaty WM_TIMER */
            SetTimer(okno,1,100,NULL);
          }
          break;
        case 102:
          // Uytkownik wcisn przycisk Stop
          if(otwarty)
          {
            mciSendString("stop 1", NULL, 0, NULL);
            // Wycz uyty zegar
            KillTimer(okno,1);
          }
          break;
      }
      return 0;
    case WM_DESTROY:
      // Zamknij odtwarzany plik
      if(otwarty)
        mciSendString("close 1 wait", NULL, 0, NULL);
      // Wycz uyty zegar
      KillTimer(okno,1);
      PostQuitMessage(0); /* zakocz program */
      return 0;
    default:
      return DefWindowProc(okno, komunikat, 
                           wParam, lParam);
  }
}

/* Funkcja wywietlajca wsplne okno dialogowe 
   Otwrz z podgldem plikw AVI */
BOOL Otworz(HWND okno, char *plik, int rozmiar, 
            char *filtry)
{
  OPENFILENAME ofn;
  char szDirName[256];

  // Wpisz zero do bufora na nazw pliku
  plik[0] = 0;
  // Odczytaj biecy katalog
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  
  // Wypenij zerami wszystkie pola struktury ofn
  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = okno;
  ofn.lpstrFilter = filtry;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= plik;
  ofn.nMaxFile = rozmiar;
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST 
     | OFN_FILEMUSTEXIST;

  return GetOpenFileNamePreview(&ofn); 
}
