// Uchwyt okna dialogowego Otwrz
HWND dialog;
// Uchwyt obiektu STATIC wywietlajcego podgld pliku
HWND podglad;

// Funkcja filtrujca
UINT APIENTRY FunkcjaPodgladu(HWND child, UINT komunikat, 
                              WPARAM wParam, LPARAM lParam)
{
  switch(komunikat)
  {
    case WM_INITDIALOG:
    {
      // Odczytaj uchwyt okna dialogowego
      dialog = GetParent(child);
      // Pobierz jego wymiary
      RECT prost;
      GetWindowRect(dialog, &prost);
      // Zwiksz szeroko okna o 200
      SetWindowPos(dialog, HWND_TOP, 0, 0, 
        prost.right - prost.left + 200,
        prost.bottom - prost.top, SWP_NOMOVE);
      /* Stwrz obiekt STATIC uywany do wywietlania 
         podgldu aktualnie wybranego pliku */
      podglad = CreateWindowEx(WS_EX_CLIENTEDGE, "STATIC",
                               "", WS_CHILD | WS_VISIBLE, 
                               prost.right - prost.left + 5,
                               36, 180, 180, dialog, 
                               NULL, zadanie, NULL);
      return FALSE;
    }
    case WM_NOTIFY:
      if(((LPOFNOTIFY)lParam)->hdr.code == CDN_SELCHANGE)
      {
        char bufor[256];
        // Odczytaj nazw pliku do bufora
        CommDlg_OpenSave_GetFilePath(dialog, bufor, 256);
        char buf2[256];
        HFILE plik;
        // Otwrz wybrany plik
        plik = _lopen(bufor, OF_READ);
        if(plik != HFILE_ERROR)
        {
          /* Odczytaj pierwsze 256 bajtw z pliku
             i wywietl w oknie podgldu */
          _lread(plik, buf2, 256);
          _lclose(plik);
          SetWindowText(podglad, buf2);
        }
        else
          SetWindowText(podglad, "");
        return TRUE;
      }
  }    
  return FALSE;
}

BOOL Otworz(HWND okno, char *plik, int rozmiar, char *filtry)
{
  OPENFILENAME ofn;
  char szDirName[256];

  // Wpisz zero do bufora na nazw pliku
  plik[0] = 0;
  // Odczytaj biecy katalog
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  
  // Wypenij zerami wszystkie pola struktury ofn
  memset(&ofn, 0, sizeof(OPENFILENAME));

  /* Wpisz odpowiednie wartoci do wykorzystywanych 
     w tym przypadku pl */
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = okno;
  ofn.lpstrFilter = filtry;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= plik;
  ofn.nMaxFile = rozmiar;
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_EXPLORER | OFN_ENABLEHOOK 
    | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
  ofn.lpfnHook = FunkcjaPodgladu;
  return GetOpenFileName(&ofn); 
}

