static inline size_t sapi_cgibin_single_write(const char *str,
                                        uint str_length TSRMLS_DC)
{
    size_t ret;
    ret = fwrite(str, 1, MIN(str_length, 16384), stdout);
    return ret;
}

static int sapi_cgibin_ub_write(const char *str, uint str_length TSRMLS_DC)
{
    const char *ptr = str;
    uint remaining = str_length;
    size_t ret;

    while (remaining > 0) {
        ret = sapi_cgibin_single_write(ptr, remaining TSRMLS_CC);
        if (!ret) {
            php_handle_aborted_connection();
            return str_length - remaining;
        }
        ptr += ret;
        remaining -= ret;
    }
    return str_length;
}
