#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php.ini.h"
#include "ext/standard/info.h"
#include "zend.h"
#include "zend_default_classes.h"

ZEND_BEGIN_MODULE_GLOBALS (warn_as_except)
    ZEND_API void (*old_error_cb) (int type, const char *error_filename,
                                   const uint error_lineno, const char *format,
                                   va_list args);
    ZEND_END_MODULE_GLOBALS(warn_as_except)
    ZEND_DECLARE_MODULE_GLOBALS(warn_as_except)

#ifdef ZTS
#define EEG(v) TSRMG(warn_as_except_globals_id,zend_warn_as_except_globals *,v)
#else
#define EEG(v) (warn_as_except_globals.v)
#endif

void exception_error_cb(int type, const char *error_filename,
                        const uint error_lineno, const char *format,
                        va_list args);

PHP_MINIT_FUNCTION(warn_as_except)
{
    EEG(old_error_cb) = zend_error_cb;
    zend_error_cb = exception_error_cb;
    return SUCCESS;
}
PHP_MSHUTDOWN_FUNCTION(warn_as_except)
{
    return SUCCESS;
}

PHP_MINFO_FUNCTION(warn_as_except)
{
}

function_entry no_functions[] = {{NULL, NULL, NULL}};

zend_module_entry warn_as_except_module_entry = {
    STANDARD_MODULE_HEADER,
    "warn_as_except",
    no_functions,
    PHP_MINIT(warn_as_except),
    PHP_MSHUTDOWN(warn_as_except),
    NULL,
    NULL,
    PHP_MINFO(warn_as_except),
    "1.0",
    STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_WARN_AS_EXCEPT
ZEND_GET_MODULE(warn_as_except)
#endif
