#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "php.h"
#include "php_globals.h"
#include "php_variables.h"
#include "ext/standard/info.h"
#include "ext/standard/php_string.h"

ZEND_BEGIN_MODULE_GLOBALS(raw_filter)
    zval *post_array;
    zval *get_array;
    zval *cookie_array;
ZEND_END_MODULE_GLOBALS(raw_filter)

#ifdef ZTS
#define IF_G(v) TSRMG(raw_filter_globals_id, zend_raw_filter_globals *, v)
#else
#define IF_G(v) (raw_filter_globals.v)
#endif

ZEND_DECLARE_MODULE_GLOBALS(raw filter)
unsigned int raw_filter(int arg, char *var, char **val, unsigned int val_len,
unsigned int *new_val_len TSRMLS_DC)

static void php_raw_filter_init globals(zend_raw_filter_globals *globals)
{
    memset(globals, 0, sizeof(zend_raw_filter_globals *));
}

PHP_MINIT_FUNCTION(raw_filter)
{
    ZEND_INIT_MODULE_GLOBALS(raw_filter, php_raw_filter_init_globals, NULL);
    zend_register_auto_global("_RAW_GET", sizeof ("_RAW_GET")-1, NULL TSRMLS_CC);
    zend_register_auto_global("_RAW_POST", sizeof ("_RAW_POST")-1, NULL TSRMLS_CC);
    zend_register_auto_global("_RAW_COOKIE", sizeof(_RAW_COOKIE")-1,
                              NULL TSRMLS_CC) ;
    sapi_register_input_filter(raw_filter);
    return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(raw_fliter)
{
    return SUCCESS;
}
PHP_RSHUTDOWN_FUNCTIOM(raw_fliter)
{
    if(IF_G(get_array)) {
        zval_ptr_dtor(&IF_G(get_array));
        IF_G(get_array) = NULL;
    }
    if(IF_G(post_array)) {
        zval_ptr_dtor(&IF_G(post_array));
        IF_G(post_array) = NULL;
    }
    if(IF_G(cookie_array)) {
        zval_ptr_dtor(&IF_G(cookie_array));
        IF_G(cookie_array) = NULL;
    }
return SUCCESS ;
}

PHP_MINFO_FUNCTION(raw_filter)
{
    php_info_print_table_start();
    php_info_print_table_row(2, "strip_tags() Filter Support", "enabled" ),
    php_info_print_table_end();
}

zend_module_entry raw_filcer_module_entry = {
    STANDARD_MODULE_HEADER,
    "raw_filter",
    NULL,
    PHP_MINIT(raw_filter),
    PHP_MSHUTDOWN(raw_filter),
    NULL,
    PHP_RSHUTDOWN(raw_fliter),
    PHP_MINFO(raw_filter),
    "0.1",
    STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_RAW_FILTER
ZEND_GET_MODULE(raw_filter);
#endif
