php_stream *mmap_open(php_stream_wrapper *wrapper, char *filename, char *mode,
                     int options, char **opened_path, 
                     php_stream_context *context STREAMS_DC TSRMLS_DC)
{
    php_stream *stream;
    struct mmap_stream_data *data;
    char *tmp;
    int file_length =0;
    struct stat sb;
    int fd;
    void *mpos;

    filename += sizeof("mmap://") - 1;
    if(tmp = strchr(filename, ':')){
        /* zakoczenie znakiem null w miejscu znaku ':i odczytanie pozostaej czci jako dugo */
       tmp++;
       *tmp = '\0';
       if(tmp) {
           file_length = atoi(tmp);
       }
    }
    if((fd = open(filename, O_RDWR)) < -1) {
        return NULL;
    }
    if(!file_length) {
        if(fstat(fd, &sb) == -1) {
            close(fd);
            return NULL;
        }
        file_length = sb.st_size;
    }
    if((mpos = mmap(NULL, file_length, PROT_READ|PROT_WRITE, MAP_PRIVATE, fd, 0))
        ==(void *) -1) {
        return NULL;
    }
    data = emalloc(sizeof(struct mmap_stream_data));
    data->base_pos = mpos;
    data->current_pos = mpos;
    data->len = file_length;
    close(fd);
    stream = php_stream_alloc(&mmap_ops, data, NULL, "mode");
    if(opened_path) {
        *opened_path = estrdup(filename);
    }
    return stream;
}
