<?php
require_once 'Benchmark/Iterate.php';

class RusageBench extends Benchmark_Iterate {
  public function setMarker($name) {
    $this->markers[$name] = getrusage();
    $this->markers[$name]['ru_utime'] =
      sprintf("%6d.%06d",$this->markers[$name]['ru_utime.tv_sec'],
                         $this->markers[$name]['ru_utime.tv_usec']);
    $this->markers[$name]['ru_stime'] =
        sprintf("%6d.%06d",$this->markers[$name]['ru_stime.tv_sec'],
                           $this->markers[$name]['ru_stime.tv_usec']);
  }
  public function get() {
    $result = array();
    $total  = 0;
    $iterations = count($this->markers)/2;
    for ($i = 1; $i <= $iterations; $i++) {
      foreach( array('ru_utime', 'ru_stime') as $key) {
        $temp[$key] = ($this->markers['end_'.$i][$key] - $this->markers['start_'.$i][$key]);
        $result['mean'][$key] += ($this->markers['end_'.$i][$key] - $this->markers['start_'.$i][$key]);
      }
      $result[$i] = $temp;
    }
    foreach(array('ru_utime', 'ru_stime') as $key) {
      $result['mean'][$key] /= $iterations;
    }
    $result['iterations'] = $iterations;
    return $result;
  }
}
?>
