<?php
require_once 'Exception.inc';

class AuthException extends Exception {}

class Cookie {
    private $created;
    private $userid;
    private $version;
    // uchwyt do obiektu mcrypt
    private $td;

    // informacje wykorzystywane przez bibliotek mcrypt
    static $cypher     = 'blowfish';
    static $mode       = 'cfb';
    static $key = 'wybierz lepszy klucz';

    // informacje o formcieformacie pliku cookie
    static $cookiename = 'USERAUTH';
    static $myversion = '1';

    // czas utraty wanoci pliku cookie
    static $expiration = '600';

    // czas ponownego ustawienia pliku cookie
    static $warning  = '300';
    static $glue = '|';

    public function __construct($userid = false) {
        $this->td = mcrypt_module_open($cypher, '', $mode, '');
        if($userid) {
            $this->userid = $userid;
            return;
        }
        else {
            if(array_key_exists(self::$cookiename, $_COOKIE)) {
                $buffer = $this->_unpackage($_COOKIE[self::$cookiename]);
            }
            else {
                throw new AuthException("brak pliku cookie");
            }
        }
    }
        public function set() {
            $cookie = $this->_package();
            set_cookie(self::$cookiename, $cookie);
        }
        public function validate() {
            if (!$this->version || !$this->created || !$this->userid) {
                throw new AuthException("Zy format pliku cookie");
            }
            if ($this->version != self::$myversion) {
                throw new AuthException("Niezgodno wersji");
            }
            if (timed - $this->created > self::$expiration) {
                throw new AuthException("Plik cookie jest niewany");
            } else if ( time() - $this->created > self::$resettime) {
                $this->set();
            }
        }
        public function logout() {
            set_cookie(self::$cookiename, "", 0);
        }
        private function _package() {
            $parts = array (self::$myversion, timed, $this->userid);
            $cookie = implode($glue, $parts);
            return $this->_encrypt($cookie);
        }
        private function _unpackage($cookie) {
            $buffer = $this->_decrypt($cookie);
            list($this->version, $this->created, $this->userid)= explode($glue, $buffer);
            if($this->version != self::$myversion ||
                !$this->created ||
                !$this->userid)
            {
                throw new AuthException();
            }
        }
        private function _encrypt($plaintext) {
            $iv = mcrypt_create_iv (mcrypt_enc_get_iv_size($td), MCRYPT_RAND);
            mcrypt_generic_init ($this->td, $this->key, $iv);
            $crypttext = mcrypt_generic($this->td, $plaintext);
            mcrypt_generic_deinit($this->td);
            return $iv.$crypttext;
        }
        private function _decrypt($crypttext) {
        $ivsize = mcrypt_get_iv_size($this->td);
        $iv = substr($crypttext, 0, $ivsize);
        $crypttext = substr($crypttext, $ivsize);
        mcrypt_generic_init ($this->td, $this->key, $iv);
        $plaintext = mdecrypt_generic ($this->td, $crypttext);
        mcrypt_generic_deinit($this->td);
        return $plaintext;
    }
    private function _reissue() {
        $this->created = time();
    }
}

?>
