<?php
require_once "EmailAddress.inc";
require_once 'PHPUnit/Framework/TestSuite.php';
require_once 'PHPUnit/TextUI/TestRunner.php';

class EmailAddressTestCase extends PHPUnit_Framework_TestCase {
  public function __construct($name) {
    parent::__construct($name);
  }
  public function testLocalPart() {
    $email = new EmailAddress("george@omniti.com");
    // Sprawdzenie, czy lokalna cz adresu jest rwna 'george'
    $this->assertTrue($email->localPart == 'georg');
  }
  public function testDomain() {
    $email = new EmailAddress("george@omniti.com");
    $this->assertTrue($email->domain == 'omniti.com');
  }
}
if(realpath($_SERVER[PHP_SELF]) == __FILE__) {
  $suite = new PHPUnit_Framework_TestSuite('EmailAddressTestCase');
  PHPUnit_TextUI_TestRunner::run($suite);
}
?>
